// Source File Name:   GenericUtils.java

package it.softecspa.mvc.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import org.apache.log4j.Logger;

// Referenced classes of package it.softecspa.mvc.utils:
//            StringSplitter

public class GenericUtils {

	private static Logger logger = Logger.getLogger(GenericUtils.class);

	public GenericUtils() {
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static ArrayList purgeElenco(Comparable insieme[], Comparable sottoInsieme[]) throws Exception {
		ArrayList newElenco = new ArrayList();
		boolean trovato = false;
		for (int i = 0; i < insieme.length; i++) {
			trovato = false;
			for (int k = 0; k < sottoInsieme.length; k++) {
				if (insieme[i].compareTo(sottoInsieme[k]) != 0)
					continue;
				trovato = true;
				break;
			}

			if (!trovato)
				newElenco.add(insieme[i]);
		}

		return newElenco;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static ArrayList trasformaLista(Object array[]) throws Exception {
		ArrayList newArray = new ArrayList();
		for (int i = 0; i < array.length; i++)
			newArray.add(array[i]);

		return newArray;
	}

	public static String normalizzaPath(String path, boolean primoSep) {
		if ((path.startsWith("/") || path.startsWith("\\")) && primoSep)
			path = path.substring(1);
		if (path.endsWith("/") || path.startsWith("\\"))
			path = path.substring(0, path.length() - 1);
		return path;
	}

	public static String rimpiazzaStringa(String str, String strDaTogliere, String strDaMettere) {
		String newStr = "";
		StringSplitter sp = new StringSplitter(str, strDaTogliere);
		for (newStr = newStr + sp.nextToken(); sp.hasMoreElements(); newStr = newStr + strDaMettere + sp.nextToken())
			;
		return newStr;
	}

	public static byte[] getBytesFromStream(InputStream is) throws Exception {
		int nread = 0;
		byte buffer[] = new byte[10240];
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		while ((nread = is.read(buffer)) != -1)
			baos.write(buffer, 0, nread);
		return baos.toByteArray();
	}

	public static void closeStream(InputStream inStream) {
		try {
			if (inStream != null)
				inStream.close();
		} catch (Exception e) {
			logger.error(e);
		}
	}

	public static void closeStream(OutputStream outStream) {
		try {
			if (outStream != null)
				outStream.close();
		} catch (Exception e) {
			logger.error(e);
		}
	}

	public static double troncaDoubleSecondoDecimale(double d) {
		int tmp = (int) Math.round(d * 100D);
		double newD = (double) tmp / 100D;
		return newD;
	}

	public static boolean areEquals(double d1, double d2) {
		return Math.abs(d1 - d2) < 9.9999999999999995E-007D;
	}

	public static String sostituisciLastDir(String path, String newDir) {
		int pos = path.lastIndexOf("/");
		String newPath = path.substring(0, pos + 1) + newDir;
		return newPath;
	}

	public static String getRelativeFileName(String path) {
		int pos = path.lastIndexOf("/");
		return path.substring(pos + 1, path.length());
	}

	public static double normalizza(double num, int precisione) {
		return (double) Math.round(num * (double) precisione) / (double) precisione;
	}

	public static final double EPSILON = 9.9999999999999995E-007D;
}
