// Source File Name:   InputUtils.java

package it.softecspa.mvc.utils;

import it.softecspa.mvc.exceptions.InputValidatorException;
import it.softecspa.portal.Bundle;

import java.util.GregorianCalendar;

// Referenced classes of package it.softecspa.mvc.utils:
//            CodiceFiscale

public class InputUtils {

	public InputUtils() {
	}

	public static void checkIsNotNull(String valore) throws InputValidatorException {
		if ("".equals(valore) || valore == null)
			throw new InputValidatorException("un parametro obbligatorio \350 risultato nullo");
		else
			return;
	}

	public static String checkIsNotNull(String valore, String label) throws InputValidatorException {
		if (valore == null || valore.trim().equals(""))
			throw new InputValidatorException(label + ": " + Bundle.getInstance().getBundle().getString("msgNotBeenFilled"));
		else
			return valore;
	}

	public static String checkIsNotNull(String valore, String chiave, Object obbligatorio) throws InputValidatorException {
		if (obbligatorio != null)
			return checkIsNotNull(valore, chiave);
		else
			return valore;
	}

	public static String[] checkIsNotNull(String elenco[], String chiave) throws InputValidatorException {
		if (elenco == null || elenco.length == 0)
			throw new InputValidatorException(chiave + ": Il campo \350 risultato nullo o vuoto. ");
		else
			return elenco;
	}

	public static void checkIsNotNull(String elenco[], String chiave, Object obbligatorio) throws InputValidatorException {
		if (obbligatorio != null)
			checkIsNotNull(elenco, chiave);
	}

	public static void checkIsNum(String valore, String nomeCampo) throws InputValidatorException {
		checkIsNotNull(valore, nomeCampo);
		try {
			Double.parseDouble(valore);
		} catch (Exception e) {
			throw new InputValidatorException("il campo \"" + nomeCampo + "\" deve essere numerico");
		}
	}

	public static void checkImporto(String valore, String nomeCampo) throws InputValidatorException {
		checkIsNum(valore, nomeCampo);
		if (Double.parseDouble(valore) <= 0.0D)
			throw new InputValidatorException("il campo \"" + nomeCampo + "\" deve essere numerico positivo maggiore di 0");
		else
			return;
	}

	public static void checkIsNum(String valore, String chiave, Object obbligatorio) throws InputValidatorException {
		if (obbligatorio != null)
			checkIsNum(valore, chiave);
	}

	public static int checkIsInteger(String valore, String nomeCampo) throws InputValidatorException {
		checkIsNotNull(valore, nomeCampo);
		int numero = 0;
		try {
			numero = Integer.parseInt(valore);
		} catch (Exception e) {
			throw new InputValidatorException(nomeCampo + ". Il campo deve essere numerico intero");
		}
		return numero;
	}

	public static int checkIsIntegerMoreThanZero(String valore, String nomeCampo) throws InputValidatorException {
		checkIsNotNull(valore, nomeCampo);
		int numero = 0;
		try {
			numero = Integer.parseInt(valore);
		} catch (Exception e) {
			throw new InputValidatorException(nomeCampo + ". Il campo deve essere numerico intero");
		}
		if (numero == 0)
			throw new InputValidatorException(nomeCampo + ". Il campo deve essere numerico intero maggiore di zero");
		else
			return numero;
	}

	public static boolean checkIsInteger(String valore, String nomeCampo, Object obbligatorio) throws InputValidatorException {
		if (obbligatorio != null) {
			checkIsInteger(valore, nomeCampo);
			return true;
		} else {
			return false;
		}
	}

	public static void checkIsIntegerPositive(String valore, String nomeCampo) throws InputValidatorException {
		checkIsInteger(valore, nomeCampo);
		if (Integer.parseInt(valore) < 0)
			throw new InputValidatorException("il campo \"" + nomeCampo + "\" deve essere un numero intero positivo");
		else
			return;
	}

	public static void checkIsDecimal(String valore, String nomeCampo) throws InputValidatorException {
		checkIsNotNull(valore);
		try {
			Double.parseDouble(valore);
		} catch (Exception e) {
			throw new InputValidatorException("il campo \"" + nomeCampo + "\" deve essere numerico intero o decimale");
		}
	}

	public static void checkIsDecimalPositive(String valore, String nomeCampo) throws InputValidatorException {
		checkIsNotNull(valore, nomeCampo);
		if (Double.parseDouble(valore) < 0.0D)
			throw new InputValidatorException("il campo \"" + nomeCampo + "\" deve essere un numero positivo");
		else
			return;
	}

	public static String checkEmail(String email) throws InputValidatorException {
		if (email.indexOf('@') == -1)
			throw new InputValidatorException("Email non valida. manca il carattere \"@\"");
		if (email.substring(email.indexOf('@')).indexOf('.') == -1)
			throw new InputValidatorException("Email non valida. manca il carattere \".\"");
		else
			return email;
	}

	public static void checkObjectIsNotNull(Object valore, String chiave) throws InputValidatorException {
		if (valore == null)
			throw new InputValidatorException("Un dato obbligatorio \350 risultato nullo o vuoto. " + chiave + "=<" + valore + ">");
		else
			return;
	}

	public static String getCodFiscale(String cognome, String nome, GregorianCalendar dataNascita, String codComuneNascita, String sesso) throws Exception {
		CodiceFiscale codFisc = new CodiceFiscale();
		codFisc.setSesso(sesso);
		codFisc.setNome(nome);
		codFisc.setCognome(cognome);
		codFisc.setDataNascita(dataNascita);
		codFisc.setCodiceComune(codComuneNascita);
		return codFisc.getCodiceFiscale();
	}

	public static boolean checkPiva(String pi) {
		if (pi.length() == 0)
			return false;
		if (pi.length() != 11)
			return false;
		for (int i = 0; i < 11; i++)
			if (pi.charAt(i) < '0' || pi.charAt(i) > '9')
				return false;

		int s = 0;
		for (int i = 0; i <= 9; i += 2)
			s += pi.charAt(i) - 48;

		for (int i = 1; i <= 9; i += 2) {
			int c = 2 * (pi.charAt(i) - 48);
			if (c > 9)
				c -= 9;
			s += c;
		}

		return (10 - s % 10) % 10 == pi.charAt(10) - 48;
	}

	public static boolean isStrictPositiveDouble(String valore) {
		if (valore != null && !valore.trim().equals("")) {
			double val = Double.parseDouble(valore);
			return val > 0.0D;
		} else {
			return false;
		}
	}

	public static boolean isPositiveDouble(String valore) {
		if (valore != null && !valore.trim().equals("")) {
			double val = Double.parseDouble(valore);
			return val > 0.0D;
		} else {
			return false;
		}
	}
}
