package it.softecspa.mvc.utils;

import it.softecspa.jwebber.frameworkImpl.security.CMSAdminImplSecurityManager;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.mvc.FwGenericServlet;
import it.softecspa.mvc.businessobject.User;

import java.util.Enumeration;
import java.util.Hashtable;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

public class LogUtils {

	public static String getMessage(User user, HttpServletRequest request, FwGenericServlet gs, String customMsg) {
		return "[" + user.getIdUtente() + "]" + "\t" + "[" + user.getIdProfilo() + "]" + "\t" + "[" + request.getRemoteHost() + "]" + "\t" + "[" + request.getRemoteAddr() + "]" + "\t" + "<" + gs.getServletName() + ">" + "\t" + "<"
				+ gs.getM_ServletCode() + ">" + "\t" + "<" + customMsg + ">";
	}

	public static String getMessage(User user, HttpServletRequest request, FwGenericServlet gs) {
		return getMessage(user, request, gs, "");
	}

	@SuppressWarnings("unchecked")
	public static String getMessageWithParams(User user, HttpServletRequest request, FwGenericServlet gs, String customMsg) {
		char sep = 167 /*''*/;
		
		StringBuffer logStr = new StringBuffer();
		// Aggiunto per monitorare ip, user-agent e referer
		logStr.append(sep).append(request.getRemoteAddr()).append(sep).append((request.getHeader("user-agent") != null) ? request.getHeader("user-agent").toString() : "");
		logStr.append(sep).append((request.getHeader("referer") != null) ? request.getHeader("referer").toString() : "");

		logStr.append(sep).append(user.getIdUtente()).append(sep).append(user.getIdProfilo()).append(sep).append(gs.getServletName()).append(sep).append(gs.getM_ServletCode()).append(sep);

		Enumeration<String> paramNames = request.getParameterNames();
		StringBuffer paramServlet = new StringBuffer("");
		String paramName = null;
		boolean hasParam = false;
		while (paramNames.hasMoreElements()) {
			hasParam = true;
			paramName = (String) paramNames.nextElement();
			if (paramName.equals(CMSAdminImplSecurityManager.REQUEST_PARAM_PASSWORD))
				paramServlet.append(paramName).append("=").append("****");
			else if (request.getParameter(paramName).indexOf('\n') > 0)
				paramServlet.append(paramName).append("=").append("----");
			else
				paramServlet.append(paramName).append("=").append(request.getParameter(paramName));
			paramServlet.append(",");
		}

		if (hasParam) {
			logStr.append(paramServlet.substring(0, paramServlet.length() - 1));
		}

		logStr.append(sep).append(customMsg);
		return logStr.toString();
	}

	public static String getMessage(User user, HttpServletRequest request, FwGenericServlet gs, Hashtable<String,Object> fod) {
		return getMessageWithParams(user, request, gs, getCustomMessage(fod));
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void setCustomMessage(Hashtable fod, String msg) {
		String msgGen = (String) fod.get("CUSTOM_MSG_LABEL");
		if (msgGen == null)
			msgGen = msg;
		else
			msgGen = msgGen + "\t-\t" + msg;
		fod.put("CUSTOM_MSG_LABEL", msgGen);
	}

	public static String getCustomMessage(Hashtable<String,Object> fod) {
		String msg = (String) fod.get("CUSTOM_MSG_LABEL");
		if (msg != null) {
			return msg;
		} else {
			return "";
		}
	}

	public static void resetCustomMessage(Hashtable<String,Object> fod) {
		fod.remove("CUSTOM_MSG_LABEL");
	}

	public static void errorConTrace(Logger logger, Object appender, String msg, Throwable e) {
		if (XString.isBlankNullTrim(msg)) msg = e.toString();
		logger.error(msg, e);
		for (; javax.servlet.ServletException.class.isAssignableFrom(e.getClass()) && ((ServletException) e).getRootCause() != null; logger.error("\nRoot cause: ", e))
			e = ((ServletException) e).getRootCause();
	}

	public static void error(Logger logger, Object appender, Throwable e) {
		String message = e.toString();
		for (; javax.servlet.ServletException.class.isAssignableFrom(e.getClass()) && ((ServletException) e).getRootCause() != null; message += "\ncaused by: " + e.toString())
			e = ((ServletException) e).getRootCause();
		logger.error(message);
	}

}
