// Source File Name:   MailUtils.java

package it.softecspa.mvc.utils;

import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailUtils {

	public MailUtils() {
	}

	public static void sendMessage(String from, String to, String subject, String body, String attachFileName, String resultedFileName, String mailServer) throws AddressException, MessagingException {
		Properties props = System.getProperties();
		props.put("mail.smtp.host", mailServer);
		Session session = Session.getDefaultInstance(props, null);
		MimeMessage message = new MimeMessage(session);
		message.setFrom(new InternetAddress(from));
		message.addRecipient(javax.mail.Message.RecipientType.TO, new InternetAddress(to));
		message.setSubject(subject);
		Multipart multipart = new MimeMultipart();
		BodyPart messageBodyPart = new MimeBodyPart();
		messageBodyPart.setText(body);
		multipart.addBodyPart(messageBodyPart);
		if (attachFileName != null) {
			messageBodyPart = new MimeBodyPart();
			javax.activation.DataSource source = new FileDataSource(attachFileName);
			messageBodyPart.setDataHandler(new DataHandler(source));
			if (resultedFileName != null)
				messageBodyPart.setFileName(resultedFileName);
			else
				messageBodyPart.setFileName(attachFileName);
			multipart.addBodyPart(messageBodyPart);
		}
		message.setContent(multipart);
		Transport.send(message);
	}

	public static boolean checkCorrectAddress(String address) {
		return address.indexOf("@") > 0;
	}
}
