/*
 * Created on Sep 2, 2005
 */
package it.softecspa.mvc.utils;

import java.util.Iterator;
import java.util.Map;

/**
 * @author l.delcarlo Softec S.p.A.
 */
public class Paginatore {

	public static final String LEFT_ARROW = "&lt;--";
	public static final String RIGHT_ARROW = "--&gt;";

	/**
	 * Funzione per la generazione del codice html per la paginazione.
	 * Tipicamente le tabelle da paginare hanno una sola cella nell'ultima riga
	 * nella quale viene inserito il codice generato da questa funzione.
	 * 
	 * @param currentPage
	 *            pagina corrente
	 * @param pagesAmount
	 *            numero totale di pagine
	 * @param maxDirectLinks
	 *            numero massimo di link diretti ai numeri di pagina
	 * @param urlToCall
	 *            URL da chiamare dai link di paginazione (tipicamente il nome
	 *            di una servlet)
	 * @param urlParameter
	 *            mappa di parametri -&gt; valori da mettere in coda all'URL
	 * @return il codice HTML per la paginazione dei risultati
	 */
	@SuppressWarnings("rawtypes")
	public static String getPaginationHTMLCode(int currentPage, int pagesAmount, int maxDirectLinks, String urlToCall, Map urlParameters) {
		StringBuffer retValue = new StringBuffer();
		// Genero la stringa di parametri che deve essere eventualmente aggiunta
		// all'URL (escluso currentPage)
		String strParameters = "";
		if (!urlParameters.isEmpty()) {
			Iterator keys = urlParameters.keySet().iterator();
			while (keys.hasNext()) {
				String param = (String) keys.next();
				String value = (String) urlParameters.get(param);
				strParameters += "&" + param + "=" + value;
			}
		}

		// Genero la freccia a sinistra (Pagina precedente)
		if (currentPage > 1) // Con link
			retValue.append(createLink(urlToCall, currentPage - 1, strParameters, LEFT_ARROW));
		else
			retValue.append(LEFT_ARROW);// Senza link

		// Genero la parte in mezzo alle due frecce che contiene i link diretti
		if (pagesAmount < 3)
			retValue.append("&nbsp;&nbsp;&nbsp;");// Solo spazi
		else {// link diretti
			int firstDirectLink = 1;
			int lastDirectLink = pagesAmount;
			if (pagesAmount > maxDirectLinks) {
				int rightSpacing = (maxDirectLinks / 2);
				int leftSpacing = ((maxDirectLinks % 2) == 1) ? rightSpacing : (rightSpacing - 1);
				if (currentPage <= leftSpacing + 1) // Parte dalla prima
					lastDirectLink = maxDirectLinks;
				else if (currentPage >= pagesAmount - rightSpacing) // Finisce
																	// con
																	// l'ultima
					firstDirectLink = pagesAmount - maxDirectLinks + 1;
				else {// Link a pagine centrali
					firstDirectLink = currentPage - leftSpacing;
					lastDirectLink = currentPage + rightSpacing;
				}
			}
			for (int i = firstDirectLink; i <= lastDirectLink; i++) {
				retValue.append("&nbsp;");
				if (i != currentPage)
					retValue.append(createLink(urlToCall, i, strParameters, "" + i));
				else
					retValue.append(i);
			}
			retValue.append("&nbsp;\n");
		}

		// Genero la freccia a destra
		if (currentPage < pagesAmount) // Con il link
			retValue.append(createLink(urlToCall, currentPage + 1, strParameters, RIGHT_ARROW));
		else {// senza il link
			retValue.append(RIGHT_ARROW);
			retValue.append("&nbsp;\n");
		}

		return retValue.toString();
	}

	private static String createLink(String urlToCall, int currentPage, String strParameters, String strLink) {
		StringBuffer retValue = new StringBuffer();
		retValue.append("<a href=\"");
		retValue.append(urlToCall);
		retValue.append("?currentPage=");
		retValue.append(currentPage);
		retValue.append(strParameters);
		retValue.append("\">");
		retValue.append(strLink);
		retValue.append("</a>\n");
		return retValue.toString();
	}

	/**
	 * Funzione per la generazione del codice html per la paginazione.
	 * Tipicamente le tabelle da paginare hanno una sola cella nell'ultima riga
	 * nella quale viene inserito il codice generato da questa funzione.
	 * 
	 * @param currentPage
	 *            pagina corrente
	 * @param pagesAmount
	 *            numero totale di pagine
	 * @param maxDirectLinks
	 *            numero massimo di link diretti ai numeri di pagina
	 * @param urlToCall
	 *            URL da chiamare dai link di paginazione (tipicamente il nome
	 *            di una servlet)
	 * @param urlParameter
	 *            mappa di parametri -&gt; valori da mettere in coda all'URL
	 * @return il codice HTML per la paginazione dei risultati
	 */
	public static String getPaginationHTMLCodeByForm(int currentPage, int pagesAmount, int maxDirectLinks, String jsCallBack) {
		StringBuffer retValue = new StringBuffer();

		// Genero la freccia a sinistra (Pagina precedente)
		if (currentPage > 1) // Con link
			retValue.append(createLinkForm(jsCallBack, currentPage - 1, LEFT_ARROW));

		// Genero la parte in mezzo alle due frecce che contiene i link diretti
		if (pagesAmount > 1) // link diretti
		{
			int firstDirectLink = 1;
			int lastDirectLink = pagesAmount;
			if (pagesAmount > maxDirectLinks) {
				int rightSpacing = (maxDirectLinks / 2);
				int leftSpacing = ((maxDirectLinks % 2) == 1) ? rightSpacing : (rightSpacing - 1);
				if (currentPage <= leftSpacing + 1) // Parte dalla prima
					lastDirectLink = maxDirectLinks;
				else if (currentPage >= pagesAmount - rightSpacing) // Finisce
																	// con
																	// l'ultima
					firstDirectLink = pagesAmount - maxDirectLinks + 1;
				else {// Link a pagine centrali
					firstDirectLink = currentPage - leftSpacing;
					lastDirectLink = currentPage + rightSpacing;
				}
			}
			for (int i = firstDirectLink; i <= lastDirectLink; i++) {
				retValue.append("&nbsp;");
				if (i != currentPage)
					retValue.append(createLinkForm(jsCallBack, i, "" + i));
				else
					retValue.append("<strong>" + i + "</strong>");
			}
			retValue.append("&nbsp;\n");
		}

		// Genero la freccia a destra
		if (currentPage < pagesAmount) // Con il link
			retValue.append(createLinkForm(jsCallBack, currentPage + 1, RIGHT_ARROW));

		return retValue.toString();
	}

	private static String createLinkForm(String jsCallBack, int numPage, String strLink) {
		StringBuffer retValue = new StringBuffer();
		retValue.append("<a class=\"paginatore\" href=\"javascript:" + jsCallBack + "('" + String.valueOf(numPage) + "')\">");
		retValue.append(strLink);
		retValue.append("</a>\n");
		return retValue.toString();
	}
	
	
	/**
	 * Funzione per la generazione del codice html per la paginazione.
	 * Tipicamente le tabelle da paginare hanno una sola cella nell'ultima riga nella
	 * quale viene inserito il codice generato da questa funzione.
	 * @param currentPage pagina corrente
	 * @param pagesAmount numero totale di pagine
	 * @param maxDirectLinks numero massimo di link diretti ai numeri di pagina
	 * @param urlToCall URL da chiamare dai link di paginazione (tipicamente il nome di una servlet)
	 * @param urlParameter mappa di parametri -&gt; valori da mettere in coda all'URL
	 * @return il codice HTML per la paginazione dei risultati
	 */
	public static String getPaginationHTMLCodeByForm(String nomeForm,int currentPage, int pagesAmount, int maxDirectLinks, String jsCallBack) {
		StringBuffer retValue = new StringBuffer();
		
		//Genero la freccia a sinistra (Pagina precedente)
		if (currentPage > 1) //Con link
			retValue.append(createLinkForm(jsCallBack, nomeForm, currentPage - 1, LEFT_ARROW));
		
		//Genero la parte in mezzo alle due frecce che contiene i link diretti
		if(pagesAmount > 1) // link diretti
		{
			int firstDirectLink = 1;
			int lastDirectLink = pagesAmount;
			if (pagesAmount > maxDirectLinks) {
				int rightSpacing = (maxDirectLinks / 2);
				int leftSpacing = ((maxDirectLinks % 2) == 1) ? rightSpacing : (rightSpacing - 1);
				if (currentPage <= leftSpacing + 1) //Parte dalla prima
					lastDirectLink = maxDirectLinks;
				else if (currentPage >= pagesAmount - rightSpacing) //Finisce con l'ultima
						firstDirectLink = pagesAmount - maxDirectLinks + 1;
				else {//Link a pagine centrali
					firstDirectLink = currentPage - leftSpacing;
					lastDirectLink = currentPage + rightSpacing;
				}
			}
			for (int i = firstDirectLink; i <= lastDirectLink; i++) {
				retValue.append("&nbsp;");
				if (i != currentPage)
					retValue.append(createLinkForm(jsCallBack,nomeForm, i, "" + i));
				else
					retValue.append("<strong>" + i + "</strong>");
			}
			retValue.append("&nbsp;\n");
		}
		
		//Genero la freccia a destra
		if (currentPage < pagesAmount) //Con il link
			retValue.append(createLinkForm(jsCallBack, nomeForm, currentPage + 1, RIGHT_ARROW));
		
		return retValue.toString();
	}
	
	private static String createLinkForm(String jsCallBack, String nomeForm,int numPage, String strLink) {
		StringBuffer retValue = new StringBuffer();
		retValue.append("<a class=\"paginatore\" href=\"javascript:" + jsCallBack + "('"+nomeForm+"','" + String.valueOf(numPage) + "')\">");
		retValue.append(strLink);
		retValue.append("</a>\n");
		return retValue.toString();
	}
	
	
	
}
