// Source File Name:   PresentationUtils.java

package it.softecspa.mvc.utils;

import it.softecspa.mvc.exceptions.AppException;

import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class PresentationUtils {

	public PresentationUtils() {
	}

	public static GregorianCalendar stringToGc(String dataStr, String oraStr, String sepData, String sepOra, boolean reverse) throws Exception {
		int anno = 0;
		int mese = 0;
		int giorno = 0;
		int ore = 0;
		int minuti = 0;
		int secondi = 0;
		StringTokenizer st = null;
		if (sepData != null)
			st = new StringTokenizer(dataStr, sepData);
		if (reverse) {
			if (sepData == null) {
				anno = Integer.parseInt(dataStr.substring(0, 4));
				mese = Integer.parseInt(dataStr.substring(4, 6)) - 1;
				giorno = Integer.parseInt(dataStr.substring(6));
			} else {
				anno = Integer.parseInt(st.nextToken());
				mese = Integer.parseInt(st.nextToken());
				mese--;
				giorno = Integer.parseInt(st.nextToken());
			}
		} else if (sepData == null) {
			giorno = Integer.parseInt(dataStr.substring(0, 2));
			mese = Integer.parseInt(dataStr.substring(2, 4)) - 1;
			anno = Integer.parseInt(dataStr.substring(4));
		} else {
			giorno = Integer.parseInt(st.nextToken());
			mese = Integer.parseInt(st.nextToken());
			mese--;
			anno = Integer.parseInt(st.nextToken());
		}
		if (oraStr != null && !oraStr.trim().equals(""))
			if (sepOra == null) {
				ore = Integer.parseInt(oraStr.substring(0, 2));
				minuti = Integer.parseInt(oraStr.substring(2, 4));
				secondi = Integer.parseInt(oraStr.substring(4));
			} else {
				st = new StringTokenizer(oraStr, sepOra);
				ore = Integer.parseInt(st.nextToken());
				minuti = Integer.parseInt(st.nextToken());
				secondi = Integer.parseInt(st.nextToken());
			}
		GregorianCalendar gc = new GregorianCalendar(anno, mese, giorno, ore, minuti, secondi);
		if (anno != gc.get(1) || mese + 1 != gc.get(2) + 1 || giorno != gc.get(5) || ore != gc.get(11) || minuti != gc.get(12) || secondi != gc.get(13))
			throw new AppException("La data non \350 una data valida. anno=<" + anno + ">, mese=<" + mese + ">, giorno=<" + giorno + ">, ore=<" + ore + ">, minuti=<" + minuti + ">, secondi=<" + secondi + ">");
		if (anno < 1000)
			throw new AppException("L'anno deve essere di 4 cifre. anno=<" + anno + ">, mese=<" + mese + ">, giorno=<" + giorno + ">, ore=<" + ore + ">, minuti=<" + minuti + ">, secondi=<" + secondi + ">");
		else
			return gc;
	}

	public static GregorianCalendar stringToGc(String dataStr, String oraStr, String sepData, String sepOra, boolean reverse, boolean obbligatorio) throws Exception {
		if (obbligatorio)
			return stringToGc(dataStr, oraStr, sepData, sepOra, reverse);
		if (dataStr == null || dataStr.trim().equals(""))
			return new GregorianCalendar(9999, 11, 31);
		else
			return stringToGc(dataStr, oraStr, sepData, sepOra, reverse);
	}

	public static String gcToString(GregorianCalendar gc, String cosa, boolean separator, boolean dataInversa, boolean oraSecondi) throws Exception {
		String dataStr = "";
		String dataSepChar = "";
		String oraSepChar = "";
		if (separator) {
			dataSepChar = "/";
			oraSepChar = ":";
		}
		if (cosa.toUpperCase().equals("DATA"))
			if (dataInversa) {
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(1)), 2, "0", "PRIMA");
				dataStr = dataStr + dataSepChar;
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(2) + 1), 2, "0", "PRIMA");
				dataStr = dataStr + dataSepChar;
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(5)), 2, "0", "PRIMA");
			} else {
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(5)), 2, "0", "PRIMA");
				dataStr = dataStr + dataSepChar;
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(2) + 1), 2, "0", "PRIMA");
				dataStr = dataStr + dataSepChar;
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(1)), 2, "0", "PRIMA");
			}
		if (cosa.toUpperCase().equals("ORA")) {
			dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(11)), 2, "0", "PRIMA");
			dataStr = dataStr + oraSepChar;
			dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(12)), 2, "0", "PRIMA");
			if (oraSecondi) {
				dataStr = dataStr + oraSepChar;
				dataStr = dataStr + adattaLunghezza(String.valueOf(gc.get(13)), 2, "0", "PRIMA");
			}
		}
		return dataStr;
	}

	public static String gcToString(GregorianCalendar gc, String cosa, boolean separator, boolean dataInversa, boolean oraSecondi, boolean obbligatorio) throws Exception {
		if (obbligatorio || gc != null)
			return gcToString(gc, cosa, separator, dataInversa, oraSecondi);
		else
			return "";
	}

	public static String adattaLunghezza(String str, int numCaratteri, String cosa, String dove, boolean troncare) {
		if (str.length() < numCaratteri) {
			int charToInsert = numCaratteri - str.length();
			for (int i = 0; i < charToInsert; i++) {
				if (dove.toUpperCase().equals("PRIMA"))
					str = cosa + str;
				if (dove.toUpperCase().equals("DOPO"))
					str = str + cosa;
			}

		} else if (troncare && str.length() > numCaratteri)
			str = str.substring(0, numCaratteri);
		return str;
	}

	public static String adattaLunghezza(String str, int numCaratteri, String cosa, String dove) {
		return adattaLunghezza(str, numCaratteri, cosa, dove, false);
	}

	public static String transform(String param) {
		if (param != null)
			return param;
		else
			return "";
	}
}
