// Source File Name:   SecurityUtils.java

package it.softecspa.mvc.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

// Referenced classes of package it.softecspa.mvc.utils:
//            Base64

public class SecurityUtils {

	public SecurityUtils() {
	}

	public static String generateRandomString(int lunghezza) throws Exception {
		if (lunghezza <= 0 || lunghezza > 100)
			throw new Exception("La lunghezza della stringa non \350 compresa fra 1 e 100");
		String stringPool = "@aA!bB1cC#dD2eE$fF3gG%hH4iI!bB1cC!d&jJ.oO?pP9qQ0bB1cC9d&jJ5kK6lL*mM7nN8!rR1sS7tT2uU$vV3wW%xX4yY?zZ5#_";
		double casuale = 0.0D;
		long casualeLong = 0L;
		int numeroIntero = 0;
		StringBuffer pwd = new StringBuffer();
		for (int i = 0; i < lunghezza; i++) {
			casuale = Math.random();
			casualeLong = Math.round(casuale * 100D);
			numeroIntero = (new Long(casualeLong)).intValue();
			pwd.append(stringPool.substring(numeroIntero, numeroIntero + 1));
		}

		return pwd.toString();
	}

	public static byte[] digest(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException {
		MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
		sha1.update(string.getBytes("ISO-8859-1"));
		byte digest[] = sha1.digest();
		return digest;
	}

	public static String makeStringFromBytes(byte bytes[]) {
		String result = "";
		for (int i = 0; i < bytes.length; i++) {
			int n = bytes[i];
			result = result + Math.abs(n);
		}

		return result;
	}

	public static String criptaInStringaByHash(String str) throws Exception {
		return makeStringFromBytes(digest(str));
	}

	public static String criptaPasswordInStringaByHash(String passwordInChiaro) throws Exception {
		MessageDigest md5 = MessageDigest.getInstance("MD5");
		String salt = "&s@(dfghdgf\351\350*a+$2lnd";
		md5.update((salt + passwordInChiaro).getBytes("ISO-8859-1"));
		byte digest[] = md5.digest();
		String result = Base64.encodeBytes(digest);
		return result;
	}

	public static final String CHARACTER_SET_FOR_HASH = "ISO-8859-1";
}
