// Source File Name:   PdfPUtilsLg.java

package it.softecspa.mvc.visualutils;

import java.awt.Color;
import java.util.Properties;
import java.util.StringTokenizer;

import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.markup.MarkupParser;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;

// Referenced classes of package it.softecspa.mvc.visualutils:
//            VisualUtils

public class PdfPUtilsLg extends VisualUtils {

	public PdfPUtilsLg() {
	}

	public final PdfPCell cell(String str, Properties attributes, Font font, int colspan) throws Exception {
		PdfPCell cell = new PdfPCell(new Phrase(str, font));
		String value;
		if ((value = attributes.getProperty("horizontalalign")) != null)
			cell.setHorizontalAlignment(Integer.parseInt(value));
		if ((value = attributes.getProperty("verticalalign")) != null)
			cell.setVerticalAlignment(Integer.parseInt(value));
		if ((value = attributes.getProperty("colspan")) != null)
			cell.setColspan(Integer.parseInt(value));
		if ((value = attributes.getProperty("leading")) != null)
			cell.setLeading(Float.valueOf(value + "f").floatValue(), 1.0F);
		if ((value = attributes.getProperty("nowrap")) != null)
			cell.setNoWrap((new Boolean(value)).booleanValue());
		if ((value = attributes.getProperty("borderwidth")) != null)
			cell.setBorderWidth(Float.valueOf(value + "f").floatValue());
		int border = 0;
		if ((value = attributes.getProperty("left")) != null && (new Boolean(value)).booleanValue())
			border |= 4;
		if ((value = attributes.getProperty("right")) != null && (new Boolean(value)).booleanValue())
			border |= 8;
		if ((value = attributes.getProperty("top")) != null && (new Boolean(value)).booleanValue())
			border |= 1;
		if ((value = attributes.getProperty("bottom")) != null && (new Boolean(value)).booleanValue())
			border |= 2;
		cell.setBorder(border);
		String r = attributes.getProperty("red");
		String g = attributes.getProperty("green");
		String b = attributes.getProperty("blue");
		if (r != null || g != null || b != null) {
			int red = 0;
			int green = 0;
			int blue = 0;
			if (r != null)
				red = Integer.parseInt(r);
			if (g != null)
				green = Integer.parseInt(g);
			if (b != null)
				blue = Integer.parseInt(b);
			cell.setBorderColor(new Color(red, green, blue));
		} else if ((value = attributes.getProperty("bordercolor")) != null)
			cell.setBorderColor(MarkupParser.decodeColor(value));
		r = (String) attributes.get("bgred");
		g = (String) attributes.get("bggreen");
		b = (String) attributes.get("bgblue");
		if (r != null || g != null || b != null) {
			int red = 0;
			int green = 0;
			int blue = 0;
			if (r != null)
				red = Integer.parseInt(r);
			if (g != null)
				green = Integer.parseInt(g);
			if (b != null)
				blue = Integer.parseInt(b);
			cell.setBackgroundColor(new Color(red, green, blue));
		} else if ((value = attributes.getProperty("backgroundcolor")) != null)
			cell.setBackgroundColor(MarkupParser.decodeColor(value));
		if ((value = attributes.getProperty("grayfill")) != null)
			cell.setGrayFill(Float.valueOf(value + "f").floatValue());
		cell.setLeading(8F, 1.0F);
		cell.setColspan(colspan);
		return cell;
	}

	public final PdfPCell cell(String str, Properties attributes, Font font) throws Exception {
		return cell(str, attributes, font, 1);
	}

	public final PdfPCell cell(String str, Properties attributes) throws Exception {
		return cell(str, attributes, new Font());
	}

	public final PdfPTable table(int col, int row, Properties attributes) throws Exception {
		PdfPTable table = null;
		table = new PdfPTable(col);
		String value = null;
		if ((value = attributes.getProperty("align")) != null)
			table.setHorizontalAlignment(Integer.parseInt(value));
		if ((value = attributes.getProperty("width")) != null)
			if (value.endsWith("%"))
				table.setWidthPercentage(Float.valueOf(value.substring(0, value.length() - 1) + "f").floatValue());
			else
				table.setTotalWidth(Float.parseFloat(value));
		if ((value = attributes.getProperty("widths")) != null) {
			StringTokenizer widthTokens = new StringTokenizer(value, ";");
			int i = 0;
			float widths[] = new float[col];
			while (widthTokens.hasMoreTokens()) {
				value = widthTokens.nextToken();
				widths[i] = Float.valueOf(value + "f").floatValue();
				i++;
			}
			table.setWidths(widths);
		}
		@SuppressWarnings("unused")
		int border = 0;
		if ((value = attributes.getProperty("left")) != null && (new Boolean(value)).booleanValue())
			border |= 4;
		if ((value = attributes.getProperty("right")) != null && (new Boolean(value)).booleanValue())
			border |= 8;
		if ((value = attributes.getProperty("top")) != null && (new Boolean(value)).booleanValue())
			border |= 1;
		if ((value = attributes.getProperty("bottom")) != null && (new Boolean(value)).booleanValue())
			border |= 2;
		String r = (String) attributes.get("red");
		String g = (String) attributes.get("green");
		String b = (String) attributes.get("blue");
		if (r != null || g != null || b != null) {
			@SuppressWarnings("unused")
			int red = 0;
			@SuppressWarnings("unused")
			int green = 0;
			@SuppressWarnings("unused")
			int blue = 0;
			if (r != null)
				red = Integer.parseInt(r);
			if (g != null)
				green = Integer.parseInt(g);
			if (b != null)
				blue = Integer.parseInt(b);
		} else {
			value = attributes.getProperty("bordercolor");
		}
		r = (String) attributes.get("bgred");
		g = (String) attributes.get("bggreen");
		b = (String) attributes.get("bgblue");
		if (r != null || g != null || b != null) {
			@SuppressWarnings("unused")
			int red = 0;
			@SuppressWarnings("unused")
			int green = 0;
			@SuppressWarnings("unused")
			int blue = 0;
			if (r != null)
				red = Integer.parseInt(r);
			if (g != null)
				green = Integer.parseInt(g);
			if (b != null)
				blue = Integer.parseInt(b);
		} else {
			value = attributes.getProperty("backgroundcolor");
		}
		value = attributes.getProperty("grayfill");
		return table;
	}

	public final PdfPCell cellaVuota() throws Exception {
		PdfPCell cella = new PdfPCell(new Phrase("  "));
		cella.setBorder(0);
		return cella;
	}

	public static String transform(String str) {
		if (str == null)
			return "";
		else
			return str;
	}
}
