
// Source File Name:   PdfUtilsLg.java

package it.softecspa.mvc.visualutils;

import java.awt.Color;
import java.util.Properties;
import java.util.StringTokenizer;

import com.lowagie.text.Cell;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.markup.MarkupParser;

public class PdfUtilsLg
{

    public PdfUtilsLg()
    {
    }

    public Cell cell(String str, Properties attributes, Font font, int colspan)
        throws Exception
    {
        Cell cell = new Cell();
        String value;
        if((value = attributes.getProperty("horizontalalign")) != null)
            cell.setHorizontalAlignment(value);
        if((value = attributes.getProperty("verticalalign")) != null)
            cell.setVerticalAlignment(value);
        if((value = attributes.getProperty("width")) != null)
            cell.setWidth(value);
        if((value = attributes.getProperty("colspan")) != null)
            cell.setColspan(Integer.parseInt(value));
        if((value = attributes.getProperty("rowspan")) != null)
            cell.setRowspan(Integer.parseInt(value));
        if((value = attributes.getProperty("leading")) != null)
            cell.setLeading(Float.valueOf(value + "f").floatValue());
        if((value = attributes.getProperty("header")) != null)
            cell.setHeader((new Boolean(value)).booleanValue());
        if((value = attributes.getProperty("nowrap")) != null)
            cell.setNoWrap((new Boolean(value)).booleanValue());
        if((value = attributes.getProperty("borderwidth")) != null)
            cell.setBorderWidth(Float.valueOf(value + "f").floatValue());
        int border = 0;
        if((value = attributes.getProperty("left")) != null && (new Boolean(value)).booleanValue())
            border |= 4;
        if((value = attributes.getProperty("right")) != null && (new Boolean(value)).booleanValue())
            border |= 8;
        if((value = attributes.getProperty("top")) != null && (new Boolean(value)).booleanValue())
            border |= 1;
        if((value = attributes.getProperty("bottom")) != null && (new Boolean(value)).booleanValue())
            border |= 2;
        cell.setBorder(border);
        String r = attributes.getProperty("red");
        String g = attributes.getProperty("green");
        String b = attributes.getProperty("blue");
        if(r != null || g != null || b != null)
        {
            int red = 0;
            int green = 0;
            int blue = 0;
            if(r != null)
                red = Integer.parseInt(r);
            if(g != null)
                green = Integer.parseInt(g);
            if(b != null)
                blue = Integer.parseInt(b);
            cell.setBorderColor(new Color(red, green, blue));
        } else
        if((value = attributes.getProperty("bordercolor")) != null)
            cell.setBorderColor(MarkupParser.decodeColor(value));
        r = (String)attributes.get("bgred");
        g = (String)attributes.get("bggreen");
        b = (String)attributes.get("bgblue");
        if(r != null || g != null || b != null)
        {
            int red = 0;
            int green = 0;
            int blue = 0;
            if(r != null)
                red = Integer.parseInt(r);
            if(g != null)
                green = Integer.parseInt(g);
            if(b != null)
                blue = Integer.parseInt(b);
            cell.setBackgroundColor(new Color(red, green, blue));
        } else
        if((value = attributes.getProperty("backgroundcolor")) != null)
            cell.setBackgroundColor(MarkupParser.decodeColor(value));
        if((value = attributes.getProperty("grayfill")) != null)
            cell.setGrayFill(Float.valueOf(value + "f").floatValue());
        cell.addElement(new Paragraph(str, font));
        cell.setLeading(8F);
        cell.setColspan(colspan);
        return cell;
    }

    public Cell cell(String str, Properties attributes, Font font)
        throws Exception
    {
        return cell(str, attributes, font, 1);
    }

    public Cell cell(String str, Properties attributes)
        throws Exception
    {
        return cell(str, attributes, new Font());
    }

    public Table table(int col, int row, Properties attributes)
        throws Exception
    {
        Table table = null;
        if(row > 0)
            table = new Table(col, row);
        else
            table = new Table(col);
        String value = null;
        if((value = attributes.getProperty("lastHeaderRow")) != null)
            table.setLastHeaderRow(Integer.parseInt(value));
        if((value = attributes.getProperty("align")) != null)
            table.setAlignment(value);
        if((value = attributes.getProperty("cellspacing")) != null)
            table.setSpacing(Float.valueOf(value + "f").floatValue());
        if((value = attributes.getProperty("cellpadding")) != null)
            table.setPadding(Float.valueOf(value + "f").floatValue());
        if((value = attributes.getProperty("offset")) != null)
            table.setOffset(Float.valueOf(value + "f").floatValue());
        if((value = attributes.getProperty("width")) != null)
            if(value.endsWith("%"))
                table.setWidth(Float.valueOf(value.substring(0, value.length() - 1) + "f").floatValue());
            else
                table.setAbsWidth(value);
        if((value = attributes.getProperty("widths")) != null)
        {
            StringTokenizer widthTokens = new StringTokenizer(value, ";");
            int i = 0;
            float widths[] = new float[col];
            while(widthTokens.hasMoreTokens()) 
            {
                value = widthTokens.nextToken();
                widths[i] = Float.valueOf(value + "f").floatValue();
                i++;
            }
            table.setWidths(widths);
        }
        if((value = attributes.getProperty("tablefitspage")) != null)
            table.setTableFitsPage((new Boolean(value)).booleanValue());
        if((value = attributes.getProperty("cellsfitpage")) != null)
            table.setCellsFitPage((new Boolean(value)).booleanValue());
        int border = 0;
        if((value = attributes.getProperty("left")) != null && (new Boolean(value)).booleanValue())
            border |= 4;
        if((value = attributes.getProperty("right")) != null && (new Boolean(value)).booleanValue())
            border |= 8;
        if((value = attributes.getProperty("top")) != null && (new Boolean(value)).booleanValue())
            border |= 1;
        if((value = attributes.getProperty("bottom")) != null && (new Boolean(value)).booleanValue())
            border |= 2;
        table.setBorder(border);
        String r = (String)attributes.get("red");
        String g = (String)attributes.get("green");
        String b = (String)attributes.get("blue");
        if(r != null || g != null || b != null)
        {
            int red = 0;
            int green = 0;
            int blue = 0;
            if(r != null)
                red = Integer.parseInt(r);
            if(g != null)
                green = Integer.parseInt(g);
            if(b != null)
                blue = Integer.parseInt(b);
            table.setBorderColor(new Color(red, green, blue));
        } else
        if((value = attributes.getProperty("bordercolor")) != null)
            table.setBorderColor(MarkupParser.decodeColor(value));
        r = (String)attributes.get("bgred");
        g = (String)attributes.get("bggreen");
        b = (String)attributes.get("bgblue");
        if(r != null || g != null || b != null)
        {
            int red = 0;
            int green = 0;
            int blue = 0;
            if(r != null)
                red = Integer.parseInt(r);
            if(g != null)
                green = Integer.parseInt(g);
            if(b != null)
                blue = Integer.parseInt(b);
            table.setBackgroundColor(new Color(red, green, blue));
        } else
        if((value = attributes.getProperty("backgroundcolor")) != null)
            table.setBackgroundColor(MarkupParser.decodeColor(value));
        if((value = attributes.getProperty("grayfill")) != null)
            table.setGrayFill(Float.valueOf(value + "f").floatValue());
        return table;
    }
}
