
// Source File Name:   VisualUtils.java

package it.softecspa.mvc.visualutils;

import it.softecspa.jwebber.CMSConstants;
import it.softecspa.mvc.utils.GenericUtils;
import it.softecspa.mvc.utils.PresentationUtils;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class VisualUtils
{

    public VisualUtils()
    {
    }

    public static String formattaNumero(String num)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        if(num.equals(""))
        {
            return "";
        } else
        {
            double numero = Double.parseDouble(num);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
            df.setDecimalFormatSymbols(dfs);
            df.setMinimumFractionDigits(2);
            df.setMaximumFractionDigits(2);
            df.setGroupingUsed(false);
            return df.format(numero);
        }
    }

    public static String formattaNumeroIntero(String num)
    {
        if(num.equals(""))
        {
            return "";
        } else
        {
            DecimalFormat df = new DecimalFormat();
            double numero = Double.parseDouble(num);
            DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ITALIAN);
            df.setDecimalFormatSymbols(dfs);
            df.setMinimumFractionDigits(0);
            df.setMaximumFractionDigits(0);
            df.setGroupingUsed(true);
            return df.format(numero);
        }
    }

    public static String formattaNumero(double numero)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        df.setGroupingUsed(false);
        return df.format(numero);
    }

    public static String formattaNumeroAllItaliana(double numero)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        return df.format(numero);
    }

    public static String formattaNumeroAllItaliana(BigDecimal numero)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        return df.format(numero.doubleValue());
    }

    public static String formattaNumeroAllItaliana(long numero)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(0);
        return df.format(numero);
    }

    public static String formattaNumeroAllItaliana(int numero)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(0);
        return df.format(numero);
    }

    public static String formattaNumeroAllItaliana(float numero)
    {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locale.ITALIAN);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        return df.format(numero);
    }

    public static String transform(String param)
    {
        if(param != null)
        {
            param = GenericUtils.rimpiazzaStringa(param, "\"", "&quot;");
            return param;
        } else
        {
            return "";
        }
    }

    public static String transformForScript(String param)
    {
        if(param != null)
        {
            param = GenericUtils.rimpiazzaStringa(param, "\"", "\\\"");
            param = GenericUtils.rimpiazzaStringa(param, "'", "\\'");
            return param;
        } else
        {
            return "";
        }
    }

    public static String transformForScript(int param)
    {
        return transform(param);
    }

    public static String transformForScript(GregorianCalendar param)
        throws Exception
    {
        return transform(param);
    }

    public static String transformForScriptPositivo(int param)
    {
        return transformPositivo(param);
    }

    public static String transform(long param)
    {
        return String.valueOf(param);
    }

    public static String transform(int param)
    {
        return String.valueOf(param);
    }

    public static String transform(double param)
    {
        return String.valueOf(param);
    }

    public static String transform(long param, boolean negativiBlank)
    {
        if(negativiBlank && param < 0L)
            return "";
        else
            return String.valueOf(param);
    }

    public static String transformPositivo(long param)
    {
        if(param <= 0L)
            return "";
        else
            return String.valueOf(param);
    }

    public static String transformPositivo(int param)
    {
        if(param <= 0)
            return "";
        else
            return String.valueOf(param);
    }

    public static String transformPositivo(double param)
    {
        if(param <= 0.0D)
            return "";
        else
            return String.valueOf(param);
    }

    public static String transform(int param, boolean negativiBlank)
    {
        if(negativiBlank && param < 0)
            return "";
        else
            return String.valueOf(param);
    }

    public static String transform(double param, boolean negativiBlank)
    {
        if(negativiBlank && param < 0.0D)
            return "";
        else
            return String.valueOf(param);
    }

    public static String transform(GregorianCalendar param)
        throws Exception
    {
        if(param != null)
            return PresentationUtils.gcToString(param, "DATA", true, false, false);
        else
            return "";
    }

    public static String getFiller(int i)
    {
        String tmp = "";
        for(int j = 0; j < i; j++)
            tmp = tmp + " ";

        return tmp;
    }

    public static String pad(String s, int i)
    {
        for(int j = s.length(); j < i; j++)
            s = s + s + " ";

        return s;
    }

    public static String getDataCorrente()
    {
        Calendar calendar = new GregorianCalendar();
        java.util.Date date = calendar.getTime();
        DateFormat formatter = DateFormat.getDateTimeInstance(1, 1, 
        		new Locale(CMSConstants.LANGUAGE_DEFAULT4LOCATE, CMSConstants.LANGUAGE_DEFAULT4LOCATE.toUpperCase()));
        formatter = new SimpleDateFormat("ddMMyy");
        return formatter.format(date);
    }

    public static String getData(GregorianCalendar calendar)
    {
        java.util.Date date = calendar.getTime();
        DateFormat formatter = DateFormat.getDateTimeInstance(1, 1, 
        		new Locale(CMSConstants.LANGUAGE_DEFAULT4LOCATE, CMSConstants.LANGUAGE_DEFAULT4LOCATE.toUpperCase()));
        formatter = new SimpleDateFormat("ddMMyy");
        return formatter.format(date);
    }

    public static String rimuoviVirgola(String valore)
    {
        String ret = "";
        valore.trim();
        for(int i = 0; i < valore.length(); i++)
            if(valore.charAt(i) == ',')
                ret = ret + ".";
            else
                ret = ret + valore.charAt(i);

        return ret;
    }

    public static String DATA_SEPARATOR = "/";
    public static String LABEL_CAMPO_OBBLIGATORIO = "*";

}
