package it.softecspa.portal;


import it.softecspa.database.dbconnect.Query;
import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.sql.QueryFormatter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.utils.StringSplitter;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.ServletConfig;

import org.apache.log4j.Logger;


/**
 * Singleton per la gestione della sincronizzazione tra cluster
 * Le informazioni risiedono sul database STAGE
 * 
 * @author m.veroni
 *
 */
public class ApplicationClusterInfo {
	
	Logger log = Logger.getLogger(getClass());
	
	private static ApplicationClusterInfo instance;
	
	
	private ClusterInfo_mgr manager; 
	
	private String webAppRootDirRealPath;
	private String webAppContextName;

	
	private String hostname;
	private String hostname_address;
	
	private boolean changedVersion;
	
	
	
	public class ClusterInfo {
		
		public static final String NAME = "cms_00_cluster_info";
		
		protected String backplane_hostname;
		protected String public_hostname;
		protected String address;
		protected String context;

		protected EnterpriseCalendar lifeStart;
		protected EnterpriseCalendar lifeStop;

		protected Boolean doNotUse;

		protected String version;
		
				
		
		protected void readRow(ResultSet res) throws SQLException {
			this.public_hostname = res.getString("v00_clu_hostname");
			this.context = res.getString("v00_clu_webapp");
			this.address = res.getString("v00_clu_address");
			this.lifeStart = EnterpriseCalendar.newInstance(res.getTimestamp("d00_clu_life_start"));
			this.lifeStop = EnterpriseCalendar.newInstance(res.getTimestamp("d00_clu_life_stop"));
			this.version = res.getString("v00_clu_version");
		}

		
		/**
		 * @deprecated
		 * @return
		 */
		public String getHostname() {
			return public_hostname;
		}
		
		public String getPublicHostname() {
			return public_hostname;
		}
		
		public void setPublicHostname(String hostname) {
			this.public_hostname = hostname;
		}

		public String getBackplaneHostname() {
			return backplane_hostname;
		}


		public void setBackplaneHostname(String backplane_hostname) {
			this.backplane_hostname = backplane_hostname;
		}
		
		
		
		public String getAddress() {
			return address;
		}

		public void setAddress(String address) {
			this.address = address;
		}

		public String getContext() {
			return context;
		}

		public void setContext(String context) {
			this.context = context;
		}

		public EnterpriseCalendar getLifeStart() {
			return lifeStart;
		}

		public void setLifeStart(EnterpriseCalendar lifeStart) {
			this.lifeStart = lifeStart;
		}

		public EnterpriseCalendar getLifeStop() {
			return lifeStop;
		}

		public void setLifeStop(EnterpriseCalendar lifeStop) {
			this.lifeStop = lifeStop;
		}

		public Boolean getDoNotUse() {
			return doNotUse;
		}

		public void setDoNotUse(Boolean doNotUse) {
			this.doNotUse = doNotUse;
		}

		public String getVersion() {
			return version;
		}

		public void setVersion(String version) {
			this.version = version;
		}
		
	}
	
	class ClusterInfo_mgr extends ClusterInfo {
		
		public ClusterInfo_mgr() throws SQLException {
			super();
		}
				
		private ClusterInfo_mgr(String hostname, String context) throws SQLException {
			this();
			select(hostname, context);
		}

		
		private void select(String hostname, String context) throws SQLException {
			Connection connection = null;
			Statement stmt = null;
			ResultSet res = null;
			String query = null;
			try {
				connection = DatabaseManager.getInstance().getConnection();
				query = "SELECT v00_clu_hostname" +
							 ", v00_clu_webapp" +
							 ", v00_clu_address" +
							 ", d00_clu_life_start" +
							 ", d00_clu_life_stop" +
							 ", v00_clu_version" +
					    " FROM "+ NAME +
					   " WHERE v00_clu_hostname = '"+hostname+"'" +
					     " AND v00_clu_webapp = '"+context+"'";
				stmt = connection.createStatement();
				try {
					res = stmt.executeQuery(query);
					if (res.next()) {
						readRow(res);
					}
				
				} catch (SQLException e1) {
					checkAndCreate(stmt, e1);
				}
			} catch (SQLException e) {
				QueryFormatter.logError(log, query, e);
			} finally {
				DatabaseManager.closeResultSet(res);
				DatabaseManager.closeStatement(stmt);
				DatabaseManager.closeConnection(connection);
			}
			
		}
		
		private List<ClusterInfo> selectOther(boolean active) throws SQLException {
			Connection connection = null;
			Statement stmt = null;
			ResultSet res = null;
			String query = null;
			List<ClusterInfo> list = new ArrayList<ClusterInfo>();
			try {
				connection = DatabaseManager.getInstance().getConnection();				
				query = "SELECT v00_clu_hostname" +
							 ", v00_clu_webapp" +
					         ", v00_clu_address" +
							 ", d00_clu_life_start" +
					         ", d00_clu_life_stop" +
					         ", v00_clu_version" +
					    " FROM "+ NAME +
					   " WHERE v00_clu_hostname <> '"+public_hostname+"'" +
					     " AND v00_clu_webapp = '"+context+"'" +
					     (active?" AND f00_clu_do_not_use = 0":"");
				stmt = connection.createStatement();
				try {
					res = stmt.executeQuery(query);
					
					while (res.next()) {
						ClusterInfo_mgr row = new ClusterInfo_mgr();
						row.readRow(res);
						list.add(row);
					}					
				
				} catch (SQLException e1) {
					checkAndCreate(stmt, e1);
				}
				
			} catch (SQLException e) {
				QueryFormatter.logError(log, query, e);
			} finally {
				DatabaseManager.closeResultSet(res);
				DatabaseManager.closeStatement(stmt);
				DatabaseManager.closeConnection(connection);
			}
			
			return list;
		}
		
		
		public void lifeStop() throws SQLException {
			Connection connection = null;
			Statement stmt = null;
			try {
				connection = DatabaseManager.getInstance().getConnection();
				connection.setAutoCommit(true);

				String query = "UPDATE "+NAME+
							     " SET d00_clu_life_stop = "+Query.toSQL(Query.getFunCurrentDateTime()) +
							   " WHERE v00_clu_hostname = '"+this.public_hostname+"'";
				stmt = connection.createStatement();
				stmt.executeUpdate(query);
				log.info("Cluster '" + getPublicHostname() + "' deregistered!");
			} finally {
				DatabaseManager.closeStatement(stmt);
				DatabaseManager.closeConnection(connection);
			}
		}

		public void lifeStart() throws SQLException {
			Connection connection = null;
			Statement stmt = null;
			try {
				connection = DatabaseManager.getInstance().getConnection();
				connection.setAutoCommit(true);

				String query = "UPDATE "+NAME+
							     " SET v00_clu_address = '"+this.address+"'" +
							        ", d00_clu_life_start = "+Query.toSQL(Query.getFunCurrentDateTime()) +
							        ", d00_clu_life_stop = null" +
							        ", v00_clu_version = '"+this.version+"'" +
							   " WHERE v00_clu_hostname = '"+this.public_hostname+"'" +
							     " AND v00_clu_webapp = '"+this.context+"'";
				stmt = connection.createStatement();
				
				// Sistema automatico di creazione della tabella
				int ret = 0;
				try {
					ret = stmt.executeUpdate(query);
				} catch (SQLException e1) {
					checkAndCreate(stmt, e1);
	
					// Eseguo nuovamente il comando di UPDATE
					try {
						ret = stmt.executeUpdate(query);
					} catch (SQLException e2) {
						throw e1;
					}
				}
							
				if (ret==0) {
					 query = "INSERT INTO "+NAME+
					         " (v00_clu_hostname" +
					         ", v00_clu_webapp" +
					         ", v00_clu_address" +
					         ", d00_clu_life_start" +
					         ", d00_clu_life_stop" +
					         ", v00_clu_version)" +
					         " VALUES ('"+this.public_hostname+"'" +
					         		", '"+this.context+"'" +
					         		", '"+this.address+"'" +
					         		", "+Query.toSQL(Query.getFunCurrentDateTime()) +
					         		", null" +
					         		", '"+this.version+"')";
					 stmt.executeUpdate(query);
				}
				log.info("Cluster '" + getPublicHostname() + "' registered with success!");
			} finally {
				DatabaseManager.closeStatement(stmt);
				DatabaseManager.closeConnection(connection);
			}
		}





		private void checkAndCreate(Statement stmt, SQLException e) throws SQLException {
			if (e.getMessage().contains(NAME+"' doesn't exist")) {
				// Creazione RUNTIME della tabella in modo trasparente
				String create = "CREATE TABLE cms_00_cluster_info (" +
					     		"v00_clu_hostname Varchar(100) NOT NULL," +
					     		"v00_clu_webapp Varchar(100) NOT NULL DEFAULT '/'," +
					     		"v00_clu_address Varchar(20)," +
					     		"d00_clu_life_start Datetime NOT NULL COMMENT 'Inizio sessione di vita'," +
							    "d00_clu_life_stop Datetime," +
							    "f00_clu_do_not_use Bool NOT NULL DEFAULT 0," +
							    "v00_clu_version Varchar(50)," +
							    "Primary Key (v00_clu_hostname, v00_clu_webapp)) ENGINE = MyISAM" +
							    " COMMENT = 'Autorilevamento cluster attivi';";		
				try {
					stmt.executeUpdate(create);
					log.info("New table '"+NAME+"' created");
				} catch (SQLException ec) {
					log.fatal("Problem in create table '"+NAME+"'", e);
					throw ec;
				}
			} else {
				throw e;
			}
			
		}


	}
	
	
	
	
	
	private ApplicationClusterInfo() {
		super();
		synchronized (ApplicationClusterInfo.class) {
			if (instance == null) {
				instance = this;
				log.info(ApplicationClusterInfo.class.getSimpleName()+" instance is starting!");				
			}
		}
	}

	
	public static ApplicationClusterInfo getInstance() {
		synchronized (ApplicationClusterInfo.class) {
			if (instance == null) new ApplicationClusterInfo();			
		}
		return instance;
	}
	
	
	private String maskedHostname(String mask) {
		if (mask==null) return null;
		
		// Filtraggio hostname
		String hostname_key = new String(hostname);
		if (XString.isNotBlankNull(mask)) {
			// ${hostname(0,4)}
			Matcher matcher = Pattern.compile("(\\$\\{hostname\\([0-9],[0-9]\\)\\})").matcher(mask);
			boolean found = matcher.find();
			if (found) {
				Matcher matcher2 = Pattern.compile("(\\$\\{hostname\\()([0-9],[0-9])\\)(\\})").matcher(matcher.group(1));
				matcher2.matches();
				String stringa = matcher2.group(2);
				String[] value = stringa.split(",");
				int start = Integer.parseInt(value[0]);
				int stop = Integer.parseInt(value[1]);
				hostname_key = hostname_key.substring(start, stop);
				
			// ${hostname(6)}
			} else {
				matcher = Pattern.compile("(\\$\\{hostname\\([0-9]\\)\\})").matcher(mask);
				found = matcher.find();
				if (found) {
					Matcher matcher2 = Pattern.compile("(\\$\\{hostname\\()([0-9])\\)(\\})").matcher(matcher.group(1));
					matcher2.matches();
					String value = matcher2.group(2);
					int start = Integer.parseInt(value);
					hostname_key = hostname_key.substring(start);
				
				// ${hostname}
				} else {
					matcher = Pattern.compile("(\\$\\{hostname\\})").matcher(mask);
					found = matcher.find();
				}
			} 
			
			if (found) {
				hostname_key = matcher.replaceAll(hostname_key);				
			} else {
				hostname_key = mask;
			}
		}
		// --------------------------------------
		return hostname_key;
	}

	/**
	 * @deprecated
	 * @param config
	 * @param mask
	 * @return
	 * @throws Exception
	 */
	public synchronized ApplicationClusterInfo init(ServletConfig config, String mask) throws Exception {		
		return this.init(config, mask, null);
	}
	
	public synchronized ApplicationClusterInfo init(ServletConfig config, String public_mask, String backplane_mask) throws Exception {		
		log.info("Initialize "+this.getClass().getSimpleName());
				
		
		webAppRootDirRealPath = config.getServletContext().getRealPath("/");
		if (webAppRootDirRealPath.endsWith(File.separator)) {
			webAppRootDirRealPath = webAppRootDirRealPath.substring(0, webAppRootDirRealPath.length() - 1);
		}
		for (StringSplitter sp = new StringSplitter(webAppRootDirRealPath, File.separator); sp.hasMoreElements();) {
			webAppContextName = sp.nextToken();
		}
		
		
		
		
		InetAddress addr = InetAddress.getLocalHost();
		hostname = addr.getHostName();
			
			
		
		String public_hostname = maskedHostname(public_mask);
		String backplane_hostname = maskedHostname(backplane_mask);
		if (backplane_hostname==null) backplane_hostname = public_hostname;
		
		
		String context = Parameters.getInstance().get("application.context.name","/");
		if (!context.startsWith("/")) context = "/" + context;
		if (!context.endsWith("/")) context = context + "/";			
		// Versione dell'applicazione (portale)
		Version version = Version.getInstance();
		
		try {
			try {
				manager = new ClusterInfo_mgr(public_hostname, context);
				
				// Controllo cambio versione
				this.changedVersion = !version.toString().equals(manager.getVersion());
				if (changedVersion) {
					log.info("Found new version: '"+version.toString()+"' vs '"+XString.toString(manager.getVersion(), "?")+"'");
				}				
			} catch (Exception e) {
				log.error("Impossible to recover host info from database",e);	
				if (manager==null) manager = new ClusterInfo_mgr();
			}
			
			// Aggiornamento dati
			manager.setPublicHostname(public_hostname);
			manager.setBackplaneHostname(backplane_hostname);
			//
			manager.setContext(context);
			manager.setAddress(addr.getHostAddress());
			manager.setLifeStart(EnterpriseCalendar.now());
			manager.setVersion(Version.getInstance().toString());
			
			// Registra lo start
			manager.lifeStart();			
			
		} catch (Exception e) {
			log.error("Impossible to save host info on database",e);			
		}
		return this;
	}

	
	/**
	 * Registra sul database che il nodo  stato fermato
	 */
	public void endLife() {
		log.info("Register node life stop");
		
		if (manager!=null) {
			manager.setLifeStop(EnterpriseCalendar.now());
			try {
				manager.lifeStop();
			} catch (SQLException e) {
				log.warn("Error in register life stop",e);
			}
		}		
	}

	
	
	/**
	 * Host address
	 * @return
	 */
	public String getHostAddress() {
		return (manager!=null?manager.getAddress():"?");
	}
	
	/**
	 * Host name
	 * @return
	 */
	public String getHostName() {
		return hostname;
	}
	
	
	/**
	 * @deprecated
	 * Host name, filtrato dalla maschera, con il quale  identificato il 
	 * cluster su database
	 * @return
	 */
	public String getHostNameMasked() {
		return (manager!=null?manager.getPublicHostname():"?");
	}
	
	public String getPublicHostnameMasked() {
		return (manager!=null?manager.getPublicHostname():"?");
	}
	
	public String getBackplaneHostnameMasked() {
		return (manager!=null?manager.getBackplaneHostname():"?");
	}
	
	
	/**
	 * Context name
	 * @return
	 */
	public String getContext() {
		return (manager!=null?manager.getContext():"?");
	}
	
	
	/**
	 * Nome host e indirizzo concatenati
	 * @return
	 */
	public String getHostNameAddress() {
		if (hostname_address!=null) return hostname_address;
		
		try {
			InetAddress addr = InetAddress.getLocalHost();
			hostname_address = addr.getHostName() + " [" + addr.getHostAddress() + "]";
		} catch (Exception e) {
			/* Nessuna operazione */
		}
		return hostname_address;
	}


	/**
	 * Restituisce true se esiste un cambio di versione dalla precedente
	 * @return
	 */
	public boolean changedVersion() {
		return changedVersion;
	}


	/**
	 * Versione dell'applicazione
	 * @return
	 */
	public Version getApplicationVersion() {
		return Version.getInstance();
	}
	
	
	
	
	public String getWebAppRootDirRealPath() {
		return webAppRootDirRealPath;
	}


	public String getWebAppContextName() {
		return webAppContextName;
	}


	public List<ClusterInfo> getOtherActiveCluster() throws SQLException {
		return manager.selectOther(true);
	}
	
	
	
	
}
