package it.softecspa.portal;

import it.softecspa.mvc.businessobject.User;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * @author m.veroni
 */
public class Bundle {
    
	// Singleton
	private static Bundle instance;
	
	private Bundle() {
		super();
		synchronized (Bundle.class) {
			if (instance == null) {
				instance = this;
				currentLocale = Parameters.getInstance().getChannelInfo().getDefaultLocale();
				
				// Definizione del nome del dizionario applicativo
				applicationDictionary = Parameters.getInstance().getChannelInfo().getApplicationName();
				if (applicationDictionary==null) applicationDictionary = "portal";
				applicationDictionary+="_dictionary";
			}
		}
	}

	public static Bundle getInstance() {
		synchronized (Bundle.class) {
			if (instance == null) new Bundle();
		}
		return instance;
	}
	
	
	
	
	private Locale currentLocale;
	
	private String JWEBBER_DICTIONARY = "jwebber_dictionary";
	private String applicationDictionary;
	
	
	
	public ResourceBundle getBundle() {		
		return ResourceBundle.getBundle(JWEBBER_DICTIONARY, currentLocale, Thread.currentThread().getContextClassLoader());
	}
	

	public ResourceBundle getBundle(User user) {
		if (user==null) return getBundle();
		
		//Locale locale =  new Locale(user.getLanguage(),user.getLanguage().toUpperCase());
		return ResourceBundle.getBundle(JWEBBER_DICTIONARY, user.getLocale(), Thread.currentThread().getContextClassLoader());
	}
	
	
	
	public ResourceBundle getPortalBundle() {	
		return ResourceBundle.getBundle(applicationDictionary, currentLocale/*, Thread.currentThread().getContextClassLoader()*/);
	}
	
	
	public ResourceBundle getPortalBundle(User user) {
		if (user==null) return getPortalBundle();
		
		//Locale locale =  new Locale(user.getLanguage(),user.getLanguage().toUpperCase());
		return ResourceBundle.getBundle(applicationDictionary, user.getLocale()/*, Thread.currentThread().getContextClassLoader()*/);
	}

	
	
	public String getJWebberDictionary() {
		return JWEBBER_DICTIONARY;
	}

	public String getApplicationDictionary() {
		return applicationDictionary;
	}
	
	
	
}
