package it.softecspa.portal;

import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.util.Properties;
import it.softecspa.sso.client.HttpClientSetting;
import it.softecspa.sso.common.SsoException;

import java.io.IOException;

public class DMSsoClientSettings {

	private static DMSsoClientSettings instance; 
	private HttpClientSetting settings;
	
	public DMSsoClientSettings(HttpClientSetting settings) {
		this.settings = settings;
	}

	public static DMSsoClientSettings getInstance() throws IOException, SsoException {
		synchronized (DMSsoClientSettings.class) {
			if (instance == null) {
				
				// Caricamentento della configurazione
				Parameters parameters = Parameters.getInstance();
				final String SSO = "sso.xml";
				File file = new File(parameters.getFile().getParentFile().getAbsolutePath()+ "/" + SSO);
				Properties properties = new Properties();
				properties.load(file);
				HttpClientSetting settings = new HttpClientSetting(properties);
				settings.validate();
				//
				instance = new DMSsoClientSettings(settings);
			}
		}
		return instance;
	}
	
	

	public HttpClientSetting getSettings() {
		return settings;
	}

}
