package it.softecspa.portal;

import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.util.Properties;
import it.softecspa.sso.common.SsoException;
import it.softecspa.sso.proxy.ProxedClientSetting;

import java.io.IOException;

public class DMSsoProxedSettings {

	private static DMSsoProxedSettings instance; 
	private ProxedClientSetting settings;
	
	public DMSsoProxedSettings(ProxedClientSetting settings) {
		this.settings = settings;
	}

	public static DMSsoProxedSettings getInstance() throws IOException, SsoException {
		synchronized (DMSsoProxedSettings.class) {
			if (instance == null) {
				
				// Caricamentento della configurazione
				Parameters parameters = Parameters.getInstance();
				final String SSO = "sso.xml";
				File file = new File(parameters.getFile().getParentFile().getAbsolutePath()+ "/" + SSO);
				Properties properties = new Properties();
				properties.load(file);
				ProxedClientSetting settings = new ProxedClientSetting(properties);
				settings.validate();
				//
				instance = new DMSsoProxedSettings(settings);
			}
		}
		return instance;
	}
	
	

	public ProxedClientSetting getSettings() {
		return settings;
	}

}
