package it.softecspa.portal;

import it.softecspa.mvc.businesslogic.StandardSecurityManager;
import it.softecspa.mvc.businesslogic.KeyStore; 

import org.apache.log4j.Logger;

/**
 * @author m.veroni
 */
public class KeyStorage {
    
	// Singleton
	private static KeyStorage instance;
	
	private KeyStorage() {
		super();
		synchronized (KeyStorage.class) {
			if (instance == null) {
				instance = this;
				
				
				
				
				
			}
		}
	}

	public static KeyStorage getInstance() {
		synchronized (KeyStorage.class) {
			if (instance == null) new KeyStorage();
		}
		return instance;
	}
	
	
	private KeyStore keyStore;
	
	
	public void inizialize(String clazz) throws Exception {
		Logger log = Logger.getLogger(getClass());
		
		
		if (log.isInfoEnabled()) log.info("Inizialize keystorage with class " + clazz);
		try {
			keyStore = (KeyStore)Class.forName(clazz).newInstance();
		} catch (InstantiationException e) {
			log.fatal("Keystore in initialize: ",e);
			throw new Exception(e);
		} catch (IllegalAccessException e) {
			log.fatal("Keystore in initialize: ",e);
			throw new Exception(e);
		} catch (ClassNotFoundException e) {
			log.fatal("Keystore in initialize: ",e);
			throw new Exception(e);
		}
		
		StandardSecurityManager.setSecretKey(keyStore.getKey("chiaveCifraturaSimmetrica"));		
			
	}
	
	
	
	public KeyStore getKeyStore() {
		return keyStore;
	}

	
	
	
	
	
}
