package it.softecspa.portal;


import it.softecspa.kahuna.util.Properties;

/**
 * @author m.veroni
 */
@SuppressWarnings("serial")
public class LogAnalyzerProperties extends Properties {
	
	// Singleton
	private static LogAnalyzerProperties instance;
	

	private LogAnalyzerProperties() {
		super();
		synchronized (LogAnalyzerProperties.class) {
			if (instance == null) {
				instance = this;
			}
		}
	}

	public static LogAnalyzerProperties getInstance() {
		synchronized (LogAnalyzerProperties.class) {
			if (instance == null) new LogAnalyzerProperties();
		}
		return instance;
	}
	
	
    /**
     * Configura il singletone, valorizzando le COSTANTI
     * @param prop
     * @throws Exception 
     */
	public void initialize(String filename) throws Exception {
		this.load(filename);
		/*
		Properties prop = new Properties();
		prop.load(filename);
		super.changeProperties(prop);
		*/		
	}
	
	
	
}
