package it.softecspa.portal;


import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.services.PortalSettings;
import it.softecspa.kahuna.util.Properties;

import java.util.Locale;

import javax.servlet.ServletConfig;

import org.apache.log4j.Logger;

/**
 * @author m.veroni
 */
@SuppressWarnings("serial")
public class Parameters extends Properties implements PortalSettings {
	
	private Logger log = Logger.getLogger(getClass());
	
	// Singleton
	private static Parameters instance;
	
	/**
	 * Velocizzatore
	 * @author m.veroni
	 */
	public class ContextBean {
		
		String domainName;
		String contextName;
		String portHTTP;
		String portHTTPS;
		
		String applicationName;
		String applicationTitle;
		String redirectTime;
		
		String defaultLanguage;
		Locale defaultLocale;
		
		
		private ContextBean(Parameters parameters) {

			domainName = get(APPLICATION_DOMAIN);
			contextName = (get(APPLICATION_CONTEXT_NAME)!=null?"/"+get(APPLICATION_CONTEXT_NAME):"");
			portHTTP = (get(Parameters.APPLICATION_HTTP_PORT)!=null?":"+get(APPLICATION_HTTP_PORT):"");
			portHTTPS = (get(Parameters.APPLICATION_HTTPS_PORT)!=null?":"+get(APPLICATION_HTTPS_PORT):"");
			applicationName = get(Parameters.APPLICATION_NAME);
			applicationTitle = get(Parameters.APPLICATION_TITLE,"I have no name?");
			
			redirectTime = get(Parameters.REDIRECT_TIME,"0");
			
			defaultLanguage = get(Parameters.LANGUAGE_DEFAULT,"it");
			defaultLocale = new Locale(defaultLanguage, defaultLanguage.toUpperCase());
		}

		public String getDomainName() {
			return domainName;
		}
		
		public String getContextName() {
			return contextName;
		}
		
		public String getPortHTTP() {
			return portHTTP;
		}
		
		public String getPortHTTPS() {
			return portHTTPS;
		}
		
		
		public String getApplicationName() {
			return applicationName;
		}
		
		public String getDefaultLanguage() {
			return defaultLanguage;
		}
		
		public Locale getDefaultLocale() {
			return defaultLocale;
		}

		public String getRedirectTime() {
			return redirectTime;
		}

		public String getApplicationTitle() {
			return applicationTitle;
		}
		
	}	
	
	private ContextBean channelInfo;
	
	/**
	 * @deprecated
	 */
	public static String LOG4J	= "log4j.xml";
	
	
	/**
	 * @deprecated
	 */
	public static String LANGUAGE_DEFAULT = PortalSettings.LANGUAGE_DEFAULT;
		
	/**
	 * @deprecated
	 */
	public static String DATE_FORMAT = PortalSettings.DATE_FORMAT;
	/**
	 * @deprecated
	 */
	public static String DATETIME_FORMAT = PortalSettings.DATETIME_FORMAT;
	
	
	/*
	 * Identificativi della pagine standard da richiamare
	 */
	public static int PAGE_LIST 		= 0;
	public static int PAGE_NEW 			= 1;
	public static int PAGE_EDIT 		= 2;
	public static int PAGE_DELETE 		= 3;	
	
	/**
	 * @deprecated
	 */
	public static String ID_PROFILO_ADMIN = PortalSettings.ID_PROFILO_ADMIN;
	
	
	private String webAppRootDirRealPath;
	
	

	private Parameters() {
		super();
		synchronized (Parameters.class) {
			if (instance == null) {
				instance = this;
			}
		}
	}

	public static Parameters getInstance() {
		synchronized (Parameters.class) {
			if (instance == null) new Parameters();
		}
		return instance;
	}
	
	
    /**
     * Configura il singletone, valorizzando le COSTANTI
     * @param prop
     * @throws Exception 
     */
	public synchronized void initialize(ServletConfig config, Properties prop) throws Exception {		
		super.changeProperties(prop);
		
		/* ..verificare la seguanete sostituzione
		 ServletContext context = session.getServletContext();
		 String realContextPath = context.getRealPath(request.getContextPath());
		 */
		// root webapp
		this.webAppRootDirRealPath = config.getServletContext().getRealPath("/");
		if (this.webAppRootDirRealPath.endsWith(File.separator)) {
			this.webAppRootDirRealPath = this.webAppRootDirRealPath.substring(0, this.webAppRootDirRealPath.length() - 1);
		}
		log.info("Webapp root (real) path is '"+this.webAppRootDirRealPath+"'");
		/*
		 * ATTENZIONE, mai scommentare perch c' un errore in avvio CONTEXT
		 *log.info("Webapp context is '"+config.getServletContext().getContextPath()+"'");
		 */
		// Channel info
		channelInfo = new ContextBean(this);
	}
	
	
	

	public String getWebAppRootDirRealPath() {
		return webAppRootDirRealPath;
	}

	
	public ContextBean getChannelInfo() {
		return channelInfo;
	}
	
	
	
	
}
