package it.softecspa.portal.db;

import it.softecspa.database.dbconnect.Row;
import it.softecspa.kahuna.sql.SqlWriter;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Gestione policies
 * @author m.veroni
 *
 */
public class UtentePolicies extends Row {
	
	
	
	private String idProfilo = "";
	private String idPolicy = "";
	
	
	private static SqlWriter getSelectAll() {
		SqlWriter sql = new SqlWriter();
		sql.setTables("cms_32_prof_policy");
 		sql.setColumns("id_profilo, id_policy");
 		return sql;
	}
	
	
	public static UtentePolicies[] getAllPolicies(String idProfilo) throws SQLException {
		SqlWriter sql = UtentePolicies.getSelectAll();
		sql.addWhere("id_profilo = "+sql.fStr(idProfilo));
		
		
		return (UtentePolicies[])(new UtentePolicies()).getRows(sql.costruisciSelect());			
	}


	public UtentePolicies() {
		super();
	}
	
	public UtentePolicies(String id_profilo, String id_policy) throws SQLException {
		this();
		SqlWriter sql = UtentePolicies.getSelectAll();
		sql.addWhere("id_profilo = "+sql.fStr(id_profilo) + 
				" and id_policy = "+sql.fStr(id_policy));
		
		readRow(sql.costruisciSelect());
	}
	
	protected void readRow(ResultSet rs) throws SQLException {
 		this.idProfilo = rs.getString("id_profilo");
 		this.idPolicy =  rs.getString("id_policy");
	}

	public String getIdPolicy() {
		return idPolicy;
	}
	public void setIdPolicy(String idPolicy) {
		this.idPolicy = idPolicy;
	}
	
	public String getIdProfilo() {
		return idProfilo;
	}
	public void setIdProfilo(String idProfilo) {
		this.idProfilo = idProfilo;
	}
}
