package it.softecspa.portal.db;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author d.cristofani
 */

public class UtenteProfilo extends UpdatableRow {
	// private static Logger logger = Logger.getLogger(UtenteProfilo.class);

	private String id_profilo = "";
	private String denominazione = "";

	private static String select_all = "SELECT id_profilo, denominazione FROM CMS_30_PROFILO ";

	public UtenteProfilo() {
	}

	public UtenteProfilo(String id_profilo) throws SQLException {
		String sql = select_all + "WHERE id_profilo=" + Query.toSQL(id_profilo);

		readRow(sql);
	}

	protected void readRow(ResultSet rs) throws SQLException {
		this.id_profilo = rs.getString("id_profilo");
		this.denominazione = rs.getString("denominazione");
	}

	/*
	 * Ritorna tutte i profili utente
	 */
	/**
	 * @deprecated Use {@link #getAllProfili()} instead
	 */
	public static UtenteProfilo[] getAllUtenti() throws SQLException {
		return getAllProfili();
	}

	/**
	 * Restituisce tutti i profili utente
	 */
	public static UtenteProfilo[] getAllProfili() throws SQLException {
		String sql = select_all + "ORDER BY denominazione";
		return (UtenteProfilo[]) (new UtenteProfilo()).getRows(sql.toString());
	}

	
	
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		return 0;
	}

	public String getDenominazione() {
		return denominazione;
	}

	public String getIdProfilo() {
		return id_profilo;
	}
}
