package it.softecspa.portal.utils;

import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.InputStream;

public class GraphicUtil {	
	
	/*
	 * Restituisce la dimensione di un'immagine presente su file system
	 */
	public static Dimension getImageDimension(String ImagePath) {
		try {			
			ImageInfo image = new ImageInfo();
			InputStream is = new FileInputStream(ImagePath);
			image.setInput(is);
			if(image.check()) {		    
				int width = image.getWidth();					    
				int height = image.getHeight();
				return new Dimension(width, height);
			} else {
				return new Dimension(0, 0);
			}
			
		} catch(Exception ex) {
			return new Dimension(0, 0);
		}
	}
	
	/*
	 * Restituisce le coordinate di un punto all'interno di un'immagine data la sua posizione relativa.
	 * x e y sono le distanze dal centro espresse in centesimi
	 * dim  l'immagine su cui il punto dovr andarsi a posizionare.
	 */
	public static Dimension getRelativePosition(double x, double y, Dimension dim) {		
		Double relX = new Double(dim.getWidth() * x);
		Double relY = new Double(dim.getHeight() * y);
		return new Dimension(relX.intValue(), relY.intValue());
	}	
}