package it.softecspa.task;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class DBTask extends UpdatableRow {
	
	private static final String SELECT_ALL = "SELECT" +
											" T.ID_TASK, T.RUN_ON_STARTUP, T.HOUR, T.DAY, T.RATE, T.PARAMS, T.ID_TASK_CLASS, T.TASK_DESC," +
											" T.IS_NOTIFY, T.NOTIFY_EMAIL, T.NOTIFY_SUBJECT, T.NOTIFY_MESSAGE, T.IS_STACK_TRACE," +
											" TC.NAME, TC.CLASSNAME, TC.DESCRIPTION" +
											" FROM cms_38_task T, cms_40_task_class TC" +
											" WHERE T.ID_TASK_CLASS = TC.ID ";
	
	private int idTask = 0;
	private String name = "";
	private String className = "";
	private String description = "";
	private boolean runOnStartup = false;
	private String day = "";
	private String hour = "";
	private long rate = 0;
	private String paramString = "";
	private int idTaskClass = 0;
	private String taskDesc = "";
	private String nextRunAt = "";
	private boolean isNotify = false;
	private String notifyEmail = "";
	private String notifySubject = "";
	private String notifyMessage = "";
	private boolean isStackTrace = false;

	public DBTask() {
		resetNextRunAt();
	}
	
	public DBTask(int idTask) throws SQLException {		
		String q = SELECT_ALL + " AND T.ID_TASK = " + idTask;
	    readRow(q);
	    resetNextRunAt();
	}
	
	public boolean equals(Object obj) {
		if(obj instanceof DBTask) {
			DBTask objTask = (DBTask) obj;
			if(objTask.getIdTask() == this.getIdTask()) {
				return true;
			}
		} 
		return false;		
	}
	
	public static DBTask[] getRunnablesOnStartup() throws SQLException {
		String q = SELECT_ALL + " AND T.RUN_ON_STARTUP = '1'";		
	    return (DBTask[]) (new DBTask()).getRows(q);
	}
	
	public static DBTask[] getAllTasks() throws SQLException {
		String q = SELECT_ALL;
	    return (DBTask[]) (new DBTask()).getRows(q);
	}
	
	public static DBTask[] getTaskClasses() throws SQLException {
		String q = "SELECT 0 as ID_TASK, ID AS ID_TASK_CLASS, NAME, CLASSNAME, DESCRIPTION, 0 AS RUN_ON_STARTUP, '' AS DAY, '' AS HOUR, 0 AS RATE, '' AS PARAMS FROM cms_40_task_class";
	    return (DBTask[]) (new DBTask()).getRows(q);
	}
	
	public static DBTask[] getTaskClassesById(int idTaskClass) throws SQLException {
		String q = "SELECT 0 as ID_TASK, ID AS ID_TASK_CLASS, NAME, CLASSNAME, DESCRIPTION, 0 AS RUN_ON_STARTUP, '' AS DAY, '' AS HOUR, 0 AS RATE, '' AS PARAMS FROM cms_40_task_class WHERE ID = " + idTaskClass;
	    return (DBTask[]) (new DBTask()).getRows(q);
	}
	
	public static int getNumOfTasks() throws SQLException {
		String q = "SELECT count(*) FROM cms_38_task";
	    return getInt(q);
	}	
	
	public static int getNextId() throws SQLException {
		String q = "SELECT MAX(ID_TASK)+1 FROM cms_38_task";
	    return getInt(q);
	}	
	
	protected void readRow(ResultSet rs) throws SQLException {		
		try {
			idTask = rs.getInt("ID_TASK");
			idTaskClass = rs.getInt("ID_TASK_CLASS");
			name = rs.getString("NAME");
			className = rs.getString("CLASSNAME");
			description = rs.getString("DESCRIPTION");
			runOnStartup = (rs.getInt("RUN_ON_STARTUP") == 1 ? true : false);
			day = rs.getString("DAY") == null ? "" : rs.getString("DAY");
			hour = rs.getString("HOUR") == null ? "" : rs.getString("HOUR");
			rate = rs.getLong("RATE");
			paramString = rs.getString("PARAMS") == null ? "" : rs.getString("PARAMS");		
			taskDesc = rs.getString("TASK_DESC");
			isNotify = (rs.getInt("IS_NOTIFY") == 1 ? true : false);
			notifyEmail = rs.getString("NOTIFY_EMAIL");
			notifySubject = rs.getString("NOTIFY_SUBJECT");
			notifyMessage = rs.getString("NOTIFY_MESSAGE");
			isStackTrace = (rs.getInt("IS_STACK_TRACE") == 1 ? true : false);
		} catch(Exception e) {			
		}
	}
	
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {			
		if (updateType == INSERT) {
			Query q = new Query("cms_38_task", true);			
			q.addFieldValue("ID_TASK", idTask);			
			q.addFieldValue("ID_TASK_CLASS", idTaskClass);
			q.addFieldValue("RUN_ON_STARTUP", (runOnStartup ? 1 : 0));
			q.addFieldValue("DAY", day);
			q.addFieldValue("HOUR", hour);
			q.addFieldValue("RATE", rate);	
			q.addFieldValue("PARAMS", paramString);
			q.addFieldValue("TASK_DESC", taskDesc);
			q.addFieldValue("IS_NOTIFY", (isNotify ? 1 : 0));
			q.addFieldValue("NOTIFY_EMAIL", notifyEmail);
			q.addFieldValue("NOTIFY_SUBJECT", notifySubject);
			q.addFieldValue("NOTIFY_MESSAGE", notifyMessage);
			q.addFieldValue("IS_STACK_TRACE", (isStackTrace ? 1 : 0));
			return dbs.execute(q.getQuery());
		} else if(updateType == UPDATE){
			Query q = new Query("cms_38_task", false);			
			q.addKeyFieldValue("ID_TASK", idTask);			
			q.addFieldValue("ID_TASK_CLASS", idTaskClass);
			q.addFieldValue("RUN_ON_STARTUP", (runOnStartup ? 1 : 0));
			q.addFieldValue("DAY", day);
			q.addFieldValue("HOUR", hour);
			q.addFieldValue("RATE", rate);
			q.addFieldValue("PARAMS", paramString);
			q.addFieldValue("TASK_DESC", taskDesc);
			q.addFieldValue("IS_NOTIFY", (isNotify ? 1 : 0));
			q.addFieldValue("NOTIFY_EMAIL", notifyEmail);
			q.addFieldValue("NOTIFY_SUBJECT", notifySubject);
			q.addFieldValue("NOTIFY_MESSAGE", notifyMessage);
			q.addFieldValue("IS_STACK_TRACE", (isStackTrace ? 1 : 0));
			return dbs.execute(q.getQuery());
		} else if (updateType == DELETE){						
			String sql = "DELETE FROM cms_38_task WHERE ID_TASK = " + this.getIdTask();									
			return dbs.execute(sql);			
		} else {
			return 0;
		}
	}
	
	/**
	 * Aggiorna il prossimo lancio dell timertask
	 * @return
	 */
	public long getDelay() {
		String giorno = day;
		if(giorno.equals("")) {		
			Date now = new Date();
			SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
			giorno = format.format(now);
		}
		int year = Integer.parseInt(giorno.substring(6));
		int month = Integer.parseInt(giorno.substring(3, 5));
		int date = Integer.parseInt(giorno.substring(0, 2));	
		
		String ora = hour;
		if(getHour().equals("")) {					
			Date now = new Date();
			SimpleDateFormat format = new SimpleDateFormat("HH:mm");
			setHour(format.format(now));
		}
		
		int hour = 0;
		int minute = 0;
		if (ora.indexOf(":") > 0) {
			hour = Integer.parseInt(ora.substring(0, ora.indexOf(":")));
			minute = Integer.parseInt(ora.substring(ora.indexOf(":") + 1));
		}
		
		GregorianCalendar cal = new GregorianCalendar(year, month - 1, date, hour, minute);					
		long millis = cal.getTimeInMillis();//Momento esatto per la notifica
		long oneMinuteBeforeMillis = millis - (60 * 1000);//Un minuto prima del momento esatto
		long nowMillis = System.currentTimeMillis();
		long delay = oneMinuteBeforeMillis - nowMillis;//Se Tomcat  appena partito rimando allo schedule successivo
		if (getRate() <= 0) {
			delay = 60*1000; // Un minuto
		} else {
			while (delay <= 0) {//Aggiungo il rate finch non supero l'ora corrente
			millis += (getRate() * 60000);
			delay = millis - nowMillis;
			}
		}
		
		// Aggiornamento del nextRunAt
		Date nextRun = new Date(millis);
		SimpleDateFormat nrFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
		this.nextRunAt = nrFormat.format(nextRun);
		
		return delay;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getDay() {
		return day;
	}

	public void setDay(String day) {
		this.day = day;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getHour() {
		return hour;
	}

	public void setHour(String hour) {
		this.hour = hour;
	}

	public int getIdTask() {
		return idTask;
	}

	public void setIdTask(int idTask) {
		this.idTask = idTask;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public long getRate() {
		return rate;
	}

	public void setRate(long rate) {
		this.rate = rate;
	}

	public boolean isRunOnStartup() {
		return runOnStartup;
	}

	public void setRunOnStartup(boolean runOnStartup) {
		this.runOnStartup = runOnStartup;
	}

	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}

	public int getIdTaskClass() {
		return idTaskClass;
	}

	public void setIdTaskClass(int idTaskClass) {
		this.idTaskClass = idTaskClass;
	}

	public String getTaskDesc() {
		return taskDesc;
	}

	public void setTaskDesc(String taskDesc) {
		this.taskDesc = taskDesc;
	}
	
	public String getNextRunAt() {
		return nextRunAt;
	}

	public void setNextRunAt(String nextRunAt) {
		this.nextRunAt = nextRunAt;
	}

	public void resetNextRunAt() {
		this.nextRunAt = "--/--/----- --:--";
	}

	public boolean isNotify() {
		return isNotify;
	}

	public void setNotify(boolean isNotify) {
		this.isNotify = isNotify;
	}

	public boolean isStackTrace() {
		return isStackTrace;
	}

	public void setStackTrace(boolean isStackTrace) {
		this.isStackTrace = isStackTrace;
	}

	public String getNotifyEmail() {
		return notifyEmail;
	}

	public void setNotifyEmail(String notifyEmail) {
		this.notifyEmail = notifyEmail;
	}

	public String getNotifyMessage() {
		return notifyMessage;
	}

	public void setNotifyMessage(String notifyMessage) {
		this.notifyMessage = notifyMessage;
	}

	public String getNotifySubject() {
		return notifySubject;
	}

	public void setNotifySubject(String notifySubject) {
		this.notifySubject = notifySubject;
	}
	
	
}
