package it.softecspa.task;

import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DBTaskLog extends UpdatableRow {
	
	private static final String SELECT_ALL = "SELECT ID_TASK_LOG, HASHCODE, ID_TASK, ACTION, TIME, HOUR, DAY, RATE, PARAMS FROM cms_39_task_log";
	
	public static final String ACTION_START 	= "START";
	public static final String ACTION_STOP 		= "STOP";
	public static final String ACTION_ERROR 	= "ERROR";
	
	private int idTaskLog = 0;
	private int idTask = 0;
	private String action = "";
	private Timestamp time = null;
	private String day = "";
	private String hour = "";
	private long rate = 0;
	private String paramString = "";
	private String hashcode = "";
	
	public DBTaskLog() {
		super();
	}
	
	public DBTaskLog(DBTask dbTask) {
		this.idTask = dbTask.getIdTask();
		this.day = dbTask.getDay();
		this.hour = dbTask.getHour();
		this.rate = dbTask.getRate();
		this.paramString = dbTask.getParamString();
	}
	
	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public DBTaskLog(int idTaskLog) throws SQLException {		
		String q = SELECT_ALL + " AND ID_TASK_LOG = " + idTaskLog;
	    readRow(q);
	}
	
	public static DBTaskLog[] getAllTaskLogs() throws SQLException {
		String q = SELECT_ALL;
	    return (DBTaskLog[]) (new DBTaskLog()).getRows(q);
	}
	
	public static DBTaskLog[] getAllTaskLogs(int idTask) throws SQLException {
		String q = SELECT_ALL + " WHERE ID_TASK=" + idTask + " ORDER BY HASHCODE DESC";
	    return (DBTaskLog[]) (new DBTaskLog()).getRows(q);
	}
	
	public static DBTaskLog[] getAllTaskLogs(String hashcode) throws SQLException {
		String q = SELECT_ALL + " WHERE HASHCODE='" + hashcode + "'";
	    return (DBTaskLog[]) (new DBTaskLog()).getRows(q);
	}
	
	public static int getNumOfTaskLogs() throws SQLException {
		String q = "SELECT count(*) FROM cms_39_task_log";
	    return getInt(q);
	}	
	
	protected void readRow(ResultSet rs) throws SQLException {		
		try {
			idTaskLog = rs.getInt("ID_TASK_LOG");
			hashcode = rs.getString("HASHCODE");
			idTask = rs.getInt("ID_TASK");
			action = rs.getString("ACTION");
			time = rs.getTimestamp("TIME");
			day = rs.getString("DAY") == null ? "" : rs.getString("DAY");
			hour = rs.getString("HOUR") == null ? "" : rs.getString("HOUR");
			rate = rs.getLong("RATE");
			paramString = rs.getString("PARAMS") == null ? "" : rs.getString("PARAMS");		
		} catch(Exception e) {			
		}
	}
	
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {			
		if (updateType == INSERT) {
			Query q = new Query("cms_39_task_log", true);			
			q.addFieldValue("HASHCODE", hashcode);
			q.addFieldValue("ID_TASK", idTask);			
			q.addFieldValue("TIME", EnterpriseCalendar.now().format("yyyy-MM-dd HH:mm:ss"));
			q.addFieldValue("ACTION", action);
			q.addFieldValue("DAY", day);
			q.addFieldValue("HOUR", hour);
			q.addFieldValue("RATE", rate);	
			q.addFieldValue("PARAMS", paramString);
			return dbs.execute(q.getQuery());
			
		} else if(updateType == UPDATE){
			return 0;
			
		} else if (updateType == DELETE){						
			if (time!=null) {
				String sql="delete FROM cms_39_task_log where TIME < " + Query.toSQLDateTime(new Date(time.getTime()));
				return dbs.execute(sql);			
			}	
		}
		
		return 0;
	}

	public String getDay() {
		return day;
	}

	public void setDay(String day) {
		this.day = day;
	}

	public String getHour() {
		return hour;
	}

	public void setHour(String hour) {
		this.hour = hour;
	}

	public int getIdTask() {
		return idTask;
	}

	public void setIdTask(int idTask) {
		this.idTask = idTask;
	}

	public int getIdTaskLog() {
		return idTaskLog;
	}

	public void setIdTaskLog(int idTaskLog) {
		this.idTaskLog = idTaskLog;
	}

	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}

	public long getRate() {
		return rate;
	}

	public void setRate(long rate) {
		this.rate = rate;
	}

	public Timestamp getTime() {
		return time;
	}

	public void setTime(Timestamp time) {
		this.time = time;
	}
	public String getHashcode() {
		return hashcode;
	}
	public void setHashcode(String hashcode) {
		this.hashcode = hashcode;
	}
}
