package it.softecspa.task;

import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.kahuna.mail12.Lettera;
import it.softecspa.kahuna.mail12.MailException;
import it.softecspa.kahuna.services.PostOffice;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.portal.ApplicationClusterInfo;
import it.softecspa.portal.Parameters;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

import javax.mail.internet.AddressException;
import javax.servlet.ServletConfig;

import org.apache.log4j.Logger;

public abstract class WebTimerTask extends TimerTask {

	private Logger log = Logger.getLogger(getClass());
	private Parameters parameters = Parameters.getInstance();

	protected DBTask dbTask = null;
	protected Hashtable<String, String> params = null;
	protected boolean isScheduled = false;
	protected boolean isRunning = false;
	protected boolean isRunError = false;

	protected ServletConfig config = null;
	
	private Timer linked_timer;

	
	/*
	 * Per ottenere i parametri di inizializzazione del Thread da lanciare viene
	 * letta da DB una stringa strutturata nel seguente modo:
	 * ParamName1=ParamValue1;ParamName2=ParamValue2;..... I valori vengono
	 * inseriti in un Hashtable
	 */
	public void readParams(String paramString) {
		if (paramString != null && !paramString.trim().equals("")) {
			params = new Hashtable<String, String>();
			StringTokenizer tokenizer = new StringTokenizer(paramString, ";");
			while (tokenizer.hasMoreTokens()) {
				String token = tokenizer.nextToken().trim();
				StringTokenizer tokenizer2 = new StringTokenizer(token, "=");
				String paramName = null;
				String paramValue = null;
				int i = 0;
				while (tokenizer2.hasMoreTokens()) {
					if (i == 0) {
						paramName = tokenizer2.nextToken().trim();
					} else {
						paramValue = tokenizer2.nextToken().trim();
					}
					i++;
				}
				if (paramName != null && paramValue != null) {
					params.put(paramName, paramValue);
				}
			}
		} else {
			params = new Hashtable<String, String>();
		}
		setParams();
	}

	protected abstract void setConfig(ServletConfig config);

	public ServletConfig getConfig() {
		return config;
	}

	protected abstract void setParams();

	protected abstract void doRun() throws Exception;

	public void run() {
		try {
			this.isRunning = true;
			String hashcode = System.currentTimeMillis() + "-" + this.hashCode();
			DBTaskLog dbTaskLog = null;
			
			// Estrazione DBTask dal database
			try {
				if (dbTask != null) {
					dbTask = new DBTask(dbTask.getIdTask());
				}
			} catch (NoRecordFoundException e) {
				// Nessuna operazione, record non trovato
			} catch (SQLException e) {
				log.error("Error in accessig task log database",e);
			}
			
			// 
			try {
				if (dbTask != null) {
					dbTaskLog = new DBTaskLog(this.dbTask);
				}
				if (dbTaskLog != null) {
					dbTaskLog.setHashcode(hashcode);
					dbTaskLog.setAction(DBTaskLog.ACTION_START);
					dbTaskLog.insert(DatabaseManager.getInstance().getCMSConnectionManager());
				}
			} catch (SQLException e) {
				log.error("Error in register START in timertask thread",e);
			}
			
			
			try {
				this.doRun();
			} catch (Exception e) {
				this.isRunError = true;
				log.error("Unhandled exception in running thread", e);
	
				if (dbTask != null && dbTask.isNotify()) {
					String[] listNotifyEmail = dbTask.getNotifyEmail().split(",");
					for (int i = 0; i < listNotifyEmail.length; i++) {
						try {
							PostOffice postOffice = PostOffice.getInstance();
							if (postOffice != null) {
								Lettera lettera = new Lettera();
	
								String hostname = ApplicationClusterInfo.getInstance().getHostNameAddress();
	
								String _from = parameters.get(PostOffice.MAIL_FROM);
								if (_from.indexOf("<") < 0) {
									_from = (hostname != null ? "Host " + hostname : "Unknown host") + "<" + _from + ">";
								}
								lettera.setMittente(_from);
								lettera.addDestinatario(listNotifyEmail[i]);
								lettera.setOggetto(dbTask.getNotifySubject());
								String message = "ERROR TASK: " + dbTask.getName() + "(" + dbTask.getClassName() + ")";
									   message += "\n\n " + dbTask.getNotifyMessage();
								if (dbTask.isStackTrace()) {
									message += "\n\nSTACK TRACE :";
									StackTraceElement[] st = e.getStackTrace();
									for (int y = 0; y < st.length; y++) {
										message += "\n\n " + st[y];
									}
								}
								lettera.setTesto(message);
								postOffice.spedisci(lettera);
							}
	
						} catch (MailException e2) {
							log.error("Problem sending mail", e2);
						} catch (AddressException e2) {
							log.error("Address problem sending mail", e2);
						}
					}
				}
	
				// Registrazione errore nel database dei TIMERTASK
				try {
					if (dbTaskLog != null) {
						dbTaskLog.setHashcode(hashcode);
						dbTaskLog.setAction(DBTaskLog.ACTION_ERROR);
						dbTaskLog.insert(DatabaseManager.getInstance().getCMSConnectionManager());
					}
				} catch (SQLException e2) {
					log.error("Error in register ERROR in timertask thread",e2);
				}
				
			} finally {
				try {
					if (dbTaskLog != null) {
						dbTaskLog.setHashcode(hashcode);
						dbTaskLog.setAction(DBTaskLog.ACTION_STOP);
						dbTaskLog.insert(DatabaseManager.getInstance().getCMSConnectionManager());
					}
				} catch (SQLException e) {
					log.error("Error in register STOP in timertask thread",e);
				}
				
				// Aggiorna il next run
				this.dbTask.getDelay();
				this.isRunning = false;
			}
		} catch (Exception e) {
			log.fatal("Unhandled exception in timertask run cycle",e);
		} catch (Error e) {
			log.fatal("Unhandled grave error in timertask run cycle",e);
		}
		
	}

	

	public boolean isRunning() {
		return isRunning;
	}

	public void setRunning(boolean isRunning) {
		this.isRunning = isRunning;
	}

	public boolean isScheduled() {
		return isScheduled;
	}
	
	public void setScheduled(Timer timer) {
		this.isScheduled = (timer!=null);
		this.linked_timer = timer;
	}

	public void cancelScheduling() {
		log.info("Stop "+getClass().getSimpleName()+" task #"+(getDbTask()!=null?getDbTask().getIdTask():"?"));
		
		isScheduled = false;	
		if (linked_timer!=null) {
			try {
				if (log.isDebugEnabled()) log.debug("Cancel timer linked with task #"+(getDbTask()!=null?getDbTask().getIdTask():"?"));
				linked_timer.cancel();
			} catch (Exception e) {
				log.error("Unhandled exception in cancel timer",e);
			}
			try {
				if (log.isDebugEnabled()) log.debug("Purge timer linked with task #"+(getDbTask()!=null?getDbTask().getIdTask():"?"));
				linked_timer.purge();
			} catch (Exception e) {
				log.error("Unhandled exception in purge timer",e);
			}
		}
	}
	
	public DBTask getDbTask() {
		return dbTask;
	}

	public void setDbTask(DBTask dbTask) {
		this.dbTask = dbTask;
	}

	public boolean isRunError() {
		return isRunError;
	}

	public void setRunError(boolean isRunError) {
		this.isRunError = isRunError;
	}

	public Timer getLinkedTimer() {
		return linked_timer;
	}



}
