package it.softecspa.fileproxy;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.mvc.businessobject.DatabaseManager;

import org.apache.log4j.Logger;

public class DatabaseBalancer {

	protected Logger log = Logger.getLogger(getClass());
	
	public enum Balancer {
		  STAGE(0)
		, MASTER(1);
		  
		  int i;
		  
	    private Balancer(int i) {
	    	this.i = i;
	    }

		public int index() {
			return i;
		}
	}
	
	
	private ConnectionManager[] balance_readwrite = new ConnectionManager[2];
	private ConnectionManager[] balance_readonly = new ConnectionManager[2];
		
	
	private static DatabaseBalancer instance;
	private boolean active;
	
	private DatabaseBalancer() {
		super();
		synchronized (DatabaseBalancer.class) {
			if (instance == null) {
				instance = this;
				instance.load();
			}
		}
	}

	public static DatabaseBalancer getInstance() {
		synchronized (DatabaseBalancer.class) {
			if (instance == null) new DatabaseBalancer();			
		}
		return instance;
	}
	
	
	private synchronized void load() {		
		active = false;
		log.info("Configuring "+this.getClass().getSimpleName());
		DatabaseManager dbManager = DatabaseManager.getInstance();
		
		int index = Balancer.STAGE.index();
		try {
			balance_readwrite[index] = dbManager.getApplicationConnectionManager(0, false);
			log.info("- STAGE (read/write) engagged!");
			balance_readonly[index] =  dbManager.getApplicationConnectionManager(0, true);
			log.info("- STAGE (read only) engagged!");
		} catch (NullPointerException e) {
			// Databse non configurato
			log.warn("No database configured!");
			return;
		}
		
		index = Balancer.MASTER.index();
		try {
			balance_readwrite[index] = dbManager.getApplicationConnectionManager(1, false);
			log.info("- MASTER (read/write) engagged!");
			balance_readonly[index] =  dbManager.getApplicationConnectionManager(1, true);
			log.info("- MASTER (read only) engagged!");
		} catch (IndexOutOfBoundsException e) {
			// Assimilo MASTER a SLAVE
			balance_readwrite[index] = dbManager.getApplicationConnectionManager(0, false);
			log.info("- MASTER (read/write) engagged! (the same of STAGE)");
			balance_readonly[index] =  dbManager.getApplicationConnectionManager(0, true);
			log.info("- MASTER (read only) engagged! (the same of STAGE)");
		}
		active = true;
		
	}
	
	
	
	/**
	 * Restituisce il ConnectionManager in lettura/scrittura
	 * @return
	 */
	public ConnectionManager get(Balancer balance) {
		return balance_readwrite[balance.index()];
	}
	
	public ConnectionManager get(boolean stage) {
		return balance_readwrite[stage?Balancer.STAGE.index():Balancer.MASTER.index()];
	}
	
	/**
	 * Restituisce il ConnectionManager in sola lettura
	 * @return
	 */
	public ConnectionManager getReadOnly(Balancer balance) {
		return balance_readonly[balance.index()];
	}
	
	public ConnectionManager getReadOnly(boolean stage) {
		return balance_readonly[stage?Balancer.STAGE.index():Balancer.MASTER.index()];
	}
	
	
	/**
	 * Restituisce il ConnectionManager MASTER in lettura/scrittura
	 * @return
	 */
	public ConnectionManager getMaster() {
		return balance_readwrite[Balancer.MASTER.index()];
	}
	
	/**
	 * Restituisce il ConnectionManager MASTER in sola lettura
	 * @return
	 */
	public ConnectionManager getMasterReadOnly() {
		return balance_readonly[Balancer.MASTER.index()];
	}
	
	
	/**
	 * Restituisce il ConnectionManager di STAGE in lettura/scrittura
	 * @return
	 */
	public ConnectionManager getStage() {
		return balance_readwrite[Balancer.STAGE.index()];
	}
	
	/**
	 * Restituisce il ConnectionManager di STAGE in sola lettura
	 * @return
	 */
	public ConnectionManager getStageReadOnly() {
		return balance_readonly[Balancer.STAGE.index()];
	}

	public boolean isActive() {
		return active;
	}
	
	
	
	
}
