/*
 * @(#)ClusterInfo.java	1.4.4,26 custom	26/05/2010
 *
 * Built automatically by REVERSER
 */

package it.softecspa.fileproxy.db;


import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.fileproxy.db.criterias.ClusterInfoCriteria;
import it.softecspa.kahuna.sql.SqlWriter;

import java.sql.SQLException;


/**
 * Customizable manager for table T005_CLUSTER_INFO
 * Class auto generated by REVERSER, version 1.4.4,26 custom
 * 
 * @author il Vera
 */
public class ClusterInfo extends it.softecspa.fileproxy.db.skins.ClusterInfoSkin {

	private static final UpdateType START = new UpdateType();
	private static final UpdateType HEARTBEAT = new UpdateType();
	private static final UpdateType STOP = new UpdateType();

	private int beatCount;
	
	
	public ClusterInfo() {
		super();
		this.doNotUse = false;
	}

	/**
	 * Extract bean using key
	 */
	public ClusterInfo(ConnectionManager cm, String context, String hostname) throws NoRecordFoundException, SQLException {
		super(cm, context, hostname);
	}



	/**
	 * Execute select * with criteria
	 * @throws SQLException if there is an error in your query
	 */
	public static ClusterInfo[] select(ClusterInfoCriteria criteria) throws SQLException {
		SqlWriter sql = criteria.getSelect();
		return (ClusterInfo[])(new ClusterInfo()).getRows(criteria.getConnectionManager(), sql.costruisciSelect());
	}


	/**
	 * Customizable update method
	 * @param updateType operation to execute
	 * @param dbs DatabaseStatement that perform operation
	 * @return number of update rows or new autoincrement id
	 * @throws SQLException if there is an error in your query
	 */
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		// Custom UPDATE
		if (updateType == START) {
			this.lifeStop = null;
			if (super.updateRecord(UPDATE, dbs)==0) {
				super.updateRecord(INSERT, dbs);
				return -1;
			}
			return 1;
			
		} else if (updateType == HEARTBEAT) {
			dbs.hideQueryLog();
			
			SqlWriter sql = new SqlWriter();
			sql.setTables(NAME);
			sql.addColumnSET("d_last_beat"			, Query.toSQLDateTime(this.lastBeat));
			sql.addColumnSET("d_record"				, Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())));
			sql.addWhere("v_hostname = " + sql.fStr(this.hostname));
			sql.addWhere("v_context = " + sql.fStr(this.context));
			return dbs.execute(sql.costruisciUpdate());
		
		} else if (updateType == STOP) {
			SqlWriter sql = new SqlWriter();
			sql.setTables(NAME);
			sql.addColumnSET("d_life_stop"			, Query.toSQLDateTime(this.lifeStop));
			sql.addColumnSET("d_record"				, Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())));
			sql.addWhere("v_hostname = " +sql.fStr(this.hostname));
			sql.addWhere("v_context = " + sql.fStr(this.context));
			return dbs.execute(sql.costruisciUpdate());
		}
		
		// Insert here your custom code
		return super.updateRecord(updateType, dbs);
	}
	
	public final int lifeStart(ConnectionManager cm) throws SQLException {
		int ret = updateRecord(cm, START);
		
		if (ret<0) {
			// Ricarico i dati dopo l'inserimento per recuperare tutti i valori
			ClusterInfoCriteria filter = new ClusterInfoCriteria(cm);
			filter.setContext(context);
			filter.setHostname(hostname);
			readRow(cm, filter.getSelect().costruisciSelect());
			ret = 1;
		}
		//
		
		return ret;
	}
	
	
	public final int heartBeat(ConnectionManager cm) throws SQLException {
		return updateRecord(cm, HEARTBEAT);
	}
	
	public final int lifeStop(ConnectionManager cm) throws SQLException {
		return updateRecord(cm, STOP);
	}

	
	
	public int getBeatCount() {
		return beatCount;
	}

	public void resetBeatCount() {
		this.beatCount = 0;
	}
	
	public int addBeatCount() {
		return ++beatCount;
	}
}
