/*
 * @(#)Log.java	1.4.4,26 custom	26/05/2010
 *
 * Built automatically by REVERSER
 */

package it.softecspa.fileproxy.db;


import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.fileproxy.db.criterias.LogCriteria;
import it.softecspa.kahuna.sql.SqlWriter;

import java.sql.SQLException;


/**
 * Customizable manager for table T000_LOG
 * Class auto generated by REVERSER, version 1.4.4,26 custom
 * 
 * @author il Vera
 */
public class Log extends it.softecspa.fileproxy.db.skins.LogSkin {

	private static final UpdateType FLUSH = new UpdateType();
	private static final UpdateType DELETE_BEFORE = new UpdateType();
	
	
	public Log() {
		super();
		lockAutoincrementRetrieves=true;		
	}

	/**
	 * Extract bean using key
	 */
	public Log(ConnectionManager cm, Integer id) throws NoRecordFoundException, SQLException {
		super(cm, id);
	}



	/**
	 * Execute select * with criteria
	 * @throws SQLException if there is an error in your query
	 */
	public static Log[] select(LogCriteria criteria) throws SQLException {
		SqlWriter sql = criteria.getSelect();
		return (Log[])(new Log()).getRows(criteria.getConnectionManager(), sql.costruisciSelect());
	}


	/**
	 * Customizable update method
	 * @param updateType operation to execute
	 * @param dbs DatabaseStatement that perform operation
	 * @return number of update rows or new autoincrement id
	 * @throws SQLException if there is an error in your query
	 */
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		
		if (updateType == DELETE_BEFORE) {
			SqlWriter sql = new SqlWriter();
			sql.setTables(NAME);
			sql.addWhere("d_record <= " + Query.toSQLDateTime(record));
			return dbs.execute(sql.costruisciDelete());
		}
		if (updateType == FLUSH) {
			return dbs.execute("TRUNCATE TABLE "+NAME);
		}
		
		// Insert here your custom code
		return super.updateRecord(updateType, dbs);
	}

	public int deleteBefore(ConnectionManager cm) throws SQLException {
		return updateRecord(cm, DELETE_BEFORE);		
	}

	
	
	public static int flush(ConnectionManager cm) throws SQLException {
		Log log = new Log();		
		return log.updateRecord(cm, FLUSH);		
	}
	
	

}
