package it.softecspa.fileproxy.db.skins;
/*
 * @(#)ChangeLogSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;
import it.softecspa.fileproxy.db.criterias.ChangeLogCriteria;
import it.softecspa.kahuna.sql.SqlWriter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

/**
 * Abstract manager for table A001_CHANGE_LOG
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class ChangeLogSkin extends UpdatableRow implements Cloneable {


	// Table name: A001_CHANGE_LOG
	public static final String NAME = "a001_change_log";

	public static final String ALIAS = "a001";


	protected Logger log = Logger.getLogger(ChangeLogSkin.class);

	// V_CODE - VARCHAR(30) NOT NULL PK
	protected String code;

	// V_DESCRIPTION - VARCHAR(100) NOT NULL
	protected String description;

	// D_CHANGE - DATETIME NOT NULL
	protected EnterpriseCalendar change;


	protected ChangeLogSkin() {
		super();
	}

	/**
	 * Extract bean using key
	 */
	protected ChangeLogSkin(ConnectionManager cm, String code) throws NoRecordFoundException, SQLException {
		this();
		// Setup key filter values
		ChangeLogCriteria filter = new ChangeLogCriteria(cm);
		filter.setCode(code);
		readRow(cm, filter.getSelect().costruisciSelect());
	}


	public String getCode() {
		return this.code;
	}

	public void setCode(String value) {
		this.code = value;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String value) {
		this.description = value;
	}

	public EnterpriseCalendar getChange() {
		return this.change;
	}

	public void setChange(EnterpriseCalendar value) {
		this.change = value;
	}


	@Override
	public ChangeLogSkin clone() throws CloneNotSupportedException {
		ChangeLogSkin c = (ChangeLogSkin) super.clone();
		//
		// Not primitive or not immutable objects
		if (this.change!=null) c.change = (EnterpriseCalendar) this.change.clone();
		//
		return c;
	}


	/**
	 * Standard implementation of update method
	 * @param updateType operation to execute
	 * @param dbs DatabaseStatement that perform operation
	 * @return number of update rows or new autoincrement id
	 * @throws SQLException if there is an error in your query
	 */
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		SqlWriter sql = new SqlWriter();
		sql.setTables(NAME);
		if (updateType == INSERT) {
			sql.addValue("v_code"			, sql.fStr(this.code));
			sql.addValue("v_description"			, sql.fStr(this.description));
			sql.addValue("d_change"			, Query.toSQLDateTime(dbs.getDBMS(), this.change));
			int _retval = dbs.execute(sql.costruisciInsert());
			return _retval;

		} else if (updateType == UPDATE) {
			sql.addColumnSET("v_description"			, sql.fStr(this.description));
			sql.addColumnSET("d_change"			, Query.toSQLDateTime(dbs.getDBMS(), this.change));
			sql.addWhere("v_code = " +sql.fStr(this.code));
			return dbs.execute(sql.costruisciUpdate());

		} else if (updateType == DELETE) {
			sql.addWhere("v_code = " +sql.fStr(this.code));
			return dbs.execute(sql.costruisciDelete());
		}
		return 0;
	}
	
	protected void readRow(ResultSet rs) throws SQLException {
		setCode(rs.getString("v_code"));
		// -------
		setDescription(rs.getString("v_description"));
		setChange(EnterpriseCalendar.newInstance(rs.getTimestamp("d_change")));
	}

}
