package it.softecspa.fileproxy.db.skins;
/*
 * @(#)ClusterInfoSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;
import it.softecspa.fileproxy.db.criterias.ClusterInfoCriteria;
import it.softecspa.kahuna.sql.SqlWriter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

/**
 * Abstract manager for table T005_CLUSTER_INFO
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class ClusterInfoSkin extends UpdatableRow implements Cloneable {


	// Table name: T005_CLUSTER_INFO
	public static final String NAME = "t005_cluster_info";

	public static final String ALIAS = "t005";


	protected Logger log = Logger.getLogger(ClusterInfoSkin.class);

	// V_HOSTNAME - VARCHAR(100) NOT NULL PK
	protected String hostname;

	// V_CONTEXT - VARCHAR(100) NOT NULL PK
	protected String context;

	// V_ADDRESS - VARCHAR(20) nullable
	protected String address;

	// V_BACKPLANE_HOSTNAME - VARCHAR(100) nullable
	protected String backplaneHostname;

	// D_LIFE_START - DATETIME NOT NULL
	protected EnterpriseCalendar lifeStart;

	// D_LIFE_STOP - DATETIME nullable
	protected EnterpriseCalendar lifeStop;

	// D_LAST_BEAT - DATETIME NOT NULL
	protected EnterpriseCalendar lastBeat;

	// F_DO_NOT_USE - BIT NOT NULL
	protected Boolean doNotUse;

	// V_VERSION - VARCHAR(50) nullable
	protected String version;

	// D_RECORD - DATETIME NOT NULL
	protected EnterpriseCalendar record;
	protected EnterpriseCalendar old_d_record;


	protected ClusterInfoSkin() {
		super();
	}

	/**
	 * Extract bean using key
	 */
	protected ClusterInfoSkin(ConnectionManager cm, String context, String hostname) throws NoRecordFoundException, SQLException {
		this();
		// Setup key filter values
		ClusterInfoCriteria filter = new ClusterInfoCriteria(cm);
		filter.setContext(context);
		filter.setHostname(hostname);
		readRow(cm, filter.getSelect().costruisciSelect());
	}


	public String getHostname() {
		return this.hostname;
	}

	public void setHostname(String value) {
		this.hostname = value;
	}

	public String getContext() {
		return this.context;
	}

	public void setContext(String value) {
		this.context = value;
	}

	public String getAddress() {
		return this.address;
	}

	public void setAddress(String value) {
		this.address = value;
	}

	public String getBackplaneHostname() {
		return this.backplaneHostname;
	}

	public void setBackplaneHostname(String value) {
		this.backplaneHostname = value;
	}

	public EnterpriseCalendar getLifeStart() {
		return this.lifeStart;
	}

	public void setLifeStart(EnterpriseCalendar value) {
		this.lifeStart = value;
	}

	public EnterpriseCalendar getLifeStop() {
		return this.lifeStop;
	}

	public void setLifeStop(EnterpriseCalendar value) {
		this.lifeStop = value;
	}

	public EnterpriseCalendar getLastBeat() {
		return this.lastBeat;
	}

	public void setLastBeat(EnterpriseCalendar value) {
		this.lastBeat = value;
	}

	public Boolean getDoNotUse() {
		return this.doNotUse;
	}

	public void setDoNotUse(Boolean value) {
		this.doNotUse = value;
	}

	public String getVersion() {
		return this.version;
	}

	public void setVersion(String value) {
		this.version = value;
	}

	public EnterpriseCalendar getRecord() {
		return this.record;
	}

	public void setRecord(EnterpriseCalendar value) {
		this.record = value;
	}


	@Override
	public ClusterInfoSkin clone() throws CloneNotSupportedException {
		ClusterInfoSkin c = (ClusterInfoSkin) super.clone();
		//
		// Not primitive or not immutable objects
		if (this.lifeStart!=null) c.lifeStart = (EnterpriseCalendar) this.lifeStart.clone();
		if (this.lifeStop!=null) c.lifeStop = (EnterpriseCalendar) this.lifeStop.clone();
		if (this.lastBeat!=null) c.lastBeat = (EnterpriseCalendar) this.lastBeat.clone();
		if (this.record!=null) c.record = (EnterpriseCalendar) this.record.clone();
		if (this.old_d_record!=null) c.old_d_record = (EnterpriseCalendar) this.old_d_record.clone();
		//
		return c;
	}


	/**
	 * Standard implementation of update method
	 * @param updateType operation to execute
	 * @param dbs DatabaseStatement that perform operation
	 * @return number of update rows or new autoincrement id
	 * @throws SQLException if there is an error in your query
	 */
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		SqlWriter sql = new SqlWriter();
		sql.setTables(NAME);
		if (updateType == INSERT) {
			sql.addValue("v_hostname"			, sql.fStr(this.hostname));
			sql.addValue("v_context"			, sql.fStr(this.context));
			sql.addValue("v_address"			, sql.fStr(this.address));
			sql.addValue("v_backplane_hostname"			, sql.fStr(this.backplaneHostname));
			sql.addValue("d_life_start"			, Query.toSQLDateTime(dbs.getDBMS(), this.lifeStart));
			sql.addValue("d_life_stop"			, Query.toSQLDateTime(dbs.getDBMS(), this.lifeStop));
			sql.addValue("d_last_beat"			, Query.toSQLDateTime(dbs.getDBMS(), this.lastBeat));
			sql.addValue("f_do_not_use"			, sql.fNum(this.doNotUse!=null?(this.doNotUse.booleanValue()?1:0):null));
			sql.addValue("v_version"			, sql.fStr(this.version));
			sql.addValue("d_record"			, (this.record==null?Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())):Query.toSQLDateTime(dbs.getDBMS(), this.record)));
			int _retval = dbs.execute(sql.costruisciInsert());
			return _retval;

		} else if (updateType == UPDATE) {
			sql.addColumnSET("v_address"			, sql.fStr(this.address));
			sql.addColumnSET("v_backplane_hostname"			, sql.fStr(this.backplaneHostname));
			sql.addColumnSET("d_life_start"			, Query.toSQLDateTime(dbs.getDBMS(), this.lifeStart));
			sql.addColumnSET("d_life_stop"			, Query.toSQLDateTime(dbs.getDBMS(), this.lifeStop));
			sql.addColumnSET("d_last_beat"			, Query.toSQLDateTime(dbs.getDBMS(), this.lastBeat));
			sql.addColumnSET("f_do_not_use"			, sql.fNum(this.doNotUse!=null?(this.doNotUse.booleanValue()?1:0):null));
			sql.addColumnSET("v_version"			, sql.fStr(this.version));
			sql.addColumnSET("d_record"			, (this.record==null || this.record.equals(this.old_d_record)?Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())):Query.toSQLDateTime(dbs.getDBMS(), this.record)));
			sql.addWhere("v_context = " +sql.fStr(this.context));
			sql.addWhere("v_hostname = " +sql.fStr(this.hostname));
			return dbs.execute(sql.costruisciUpdate());

		} else if (updateType == DELETE) {
			sql.addWhere("v_context = " +sql.fStr(this.context));
			sql.addWhere("v_hostname = " +sql.fStr(this.hostname));
			return dbs.execute(sql.costruisciDelete());
		}
		return 0;
	}
	
	protected void readRow(ResultSet rs) throws SQLException {
		setHostname(rs.getString("v_hostname"));
		setContext(rs.getString("v_context"));
		// -------
		setAddress(rs.getString("v_address"));
		setBackplaneHostname(rs.getString("v_backplane_hostname"));
		setLifeStart(EnterpriseCalendar.newInstance(rs.getTimestamp("d_life_start")));
		setLifeStop(EnterpriseCalendar.newInstance(rs.getTimestamp("d_life_stop")));
		setLastBeat(EnterpriseCalendar.newInstance(rs.getTimestamp("d_last_beat")));
		setDoNotUse(SqlWriter.getBoolean(rs, "f_do_not_use"));
		setVersion(rs.getString("v_version"));
		setRecord(EnterpriseCalendar.newInstance(rs.getTimestamp("d_record")));
		this.old_d_record = getRecord(); // Cache della colonna D_RECORD
	}

}
