package it.softecspa.fileproxy.db.skins;
/*
 * @(#)LogSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;
import it.softecspa.fileproxy.db.criterias.LogCriteria;
import it.softecspa.kahuna.sql.SqlWriter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

/**
 * Abstract manager for table T000_LOG
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class LogSkin extends UpdatableRow implements Cloneable {


	// Table name: T000_LOG
	public static final String NAME = "t000_log";

	public static final String ALIAS = "t000";


	protected Logger log = Logger.getLogger(LogSkin.class);
	protected boolean lockAutoincrementRetrieves;

	// ID - INT(10) NOT NULL PK autoincrement
	protected Integer id;

	// V_SOURCE - VARCHAR(50) NOT NULL
	protected String source;

	// V_MESSAGE - TEXT(65535) NOT NULL
	protected String message;

	// V_STACKTRACE - TEXT(65535) nullable
	protected String stacktrace;

	// N_TICKET - INT(10) nullable
	protected Integer ticket;

	// D_RECORD - DATETIME NOT NULL
	protected EnterpriseCalendar record;
	protected EnterpriseCalendar old_d_record;


	protected LogSkin() {
		super();
	}

	/**
	 * Extract bean using key
	 */
	protected LogSkin(ConnectionManager cm, Integer id) throws NoRecordFoundException, SQLException {
		this();
		// Setup key filter values
		LogCriteria filter = new LogCriteria(cm);
		filter.setId(id);
		readRow(cm, filter.getSelect().costruisciSelect());
	}


	public Integer getId() {
		return this.id;
	}

	public void setId(Integer value) {
		this.id = value;
	}

	public String getSource() {
		return this.source;
	}

	public void setSource(String value) {
		this.source = value;
	}

	public String getMessage() {
		return this.message;
	}

	public void setMessage(String value) {
		this.message = value;
	}

	public String getStacktrace() {
		return this.stacktrace;
	}

	public void setStacktrace(String value) {
		this.stacktrace = value;
	}

	public Integer getTicket() {
		return this.ticket;
	}

	public void setTicket(Integer value) {
		this.ticket = value;
	}

	public EnterpriseCalendar getRecord() {
		return this.record;
	}

	public void setRecord(EnterpriseCalendar value) {
		this.record = value;
	}


	@Override
	public LogSkin clone() throws CloneNotSupportedException {
		LogSkin c = (LogSkin) super.clone();
		//
		// Not primitive or not immutable objects
		if (this.record!=null) c.record = (EnterpriseCalendar) this.record.clone();
		if (this.old_d_record!=null) c.old_d_record = (EnterpriseCalendar) this.old_d_record.clone();
		//
		return c;
	}


	/**
	 * Standard implementation of update method
	 * @param updateType operation to execute
	 * @param dbs DatabaseStatement that perform operation
	 * @return number of update rows or new autoincrement id
	 * @throws SQLException if there is an error in your query
	 */
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		SqlWriter sql = new SqlWriter();
		sql.setTables(NAME);
		if (updateType == INSERT) {
			sql.addValue("id"			, sql.fNum(this.id));
			sql.addValue("v_source"			, sql.fStr(this.source));
			sql.addValue("v_message"			, sql.fStr(this.message));
			sql.addValue("v_stacktrace"			, sql.fStr(this.stacktrace));
			sql.addValue("n_ticket"			, sql.fNum(this.ticket));
			sql.addValue("d_record"			, (this.record==null?Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())):Query.toSQLDateTime(dbs.getDBMS(), this.record)));
			int _retval = dbs.execute(sql.costruisciInsert());
			if (lockAutoincrementRetrieves) return _retval;

			// Calcolo del massimo progressivo e lo assegno alla chiave
			this.id = LogCriteria.getMaxId(dbs);
			return this.id.intValue();

		} else if (updateType == UPDATE) {
			sql.addColumnSET("v_source"			, sql.fStr(this.source));
			sql.addColumnSET("v_message"			, sql.fStr(this.message));
			sql.addColumnSET("v_stacktrace"			, sql.fStr(this.stacktrace));
			sql.addColumnSET("n_ticket"			, sql.fNum(this.ticket));
			sql.addColumnSET("d_record"			, (this.record==null || this.record.equals(this.old_d_record)?Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())):Query.toSQLDateTime(dbs.getDBMS(), this.record)));
			sql.addWhere("id = " +sql.fNum(this.id));
			return dbs.execute(sql.costruisciUpdate());

		} else if (updateType == DELETE) {
			sql.addWhere("id = " +sql.fNum(this.id));
			return dbs.execute(sql.costruisciDelete());
		}
		return 0;
	}
	
	protected void readRow(ResultSet rs) throws SQLException {
		setId(SqlWriter.getInteger(rs, "id"));
		// -------
		setSource(rs.getString("v_source"));
		setMessage(rs.getString("v_message"));
		setStacktrace(rs.getString("v_stacktrace"));
		setTicket(SqlWriter.getInteger(rs, "n_ticket"));
		setRecord(EnterpriseCalendar.newInstance(rs.getTimestamp("d_record")));
		this.old_d_record = getRecord(); // Cache della colonna D_RECORD
	}

}
