package it.softecspa.fileproxy.db.skins;
/*
 * @(#)ProtocolSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.NoRecordFoundException;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.database.dbconnect.UpdatableRow;
import it.softecspa.fileproxy.db.criterias.ProtocolCriteria;
import it.softecspa.kahuna.sql.SqlWriter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

/**
 * Abstract manager for table T015_PROTOCOL
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class ProtocolSkin extends UpdatableRow implements Cloneable {


	// Table name: T015_PROTOCOL
	public static final String NAME = "t015_protocol";

	public static final String ALIAS = "t015";


	protected Logger log = Logger.getLogger(ProtocolSkin.class);

	// N_PROTOCOL - INT UNSIGNED(10) NOT NULL PK
	protected Integer protocol;

	// V_NAME - VARCHAR(50) NOT NULL
	protected String name;

	// V_SERVER_VERSION - VARCHAR(50) NOT NULL
	protected String serverVersion;

	// D_RECORD - DATETIME NOT NULL
	protected EnterpriseCalendar record;
	protected EnterpriseCalendar old_d_record;


	protected ProtocolSkin() {
		super();
	}

	/**
	 * Extract bean using key
	 */
	protected ProtocolSkin(ConnectionManager cm, Integer protocol) throws NoRecordFoundException, SQLException {
		this();
		// Setup key filter values
		ProtocolCriteria filter = new ProtocolCriteria(cm);
		filter.setProtocol(protocol);
		readRow(cm, filter.getSelect().costruisciSelect());
	}


	public Integer getProtocol() {
		return this.protocol;
	}

	public void setProtocol(Integer value) {
		this.protocol = value;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String value) {
		this.name = value;
	}

	public String getServerVersion() {
		return this.serverVersion;
	}

	public void setServerVersion(String value) {
		this.serverVersion = value;
	}

	public EnterpriseCalendar getRecord() {
		return this.record;
	}

	public void setRecord(EnterpriseCalendar value) {
		this.record = value;
	}


	@Override
	public ProtocolSkin clone() throws CloneNotSupportedException {
		ProtocolSkin c = (ProtocolSkin) super.clone();
		//
		// Not primitive or not immutable objects
		if (this.record!=null) c.record = (EnterpriseCalendar) this.record.clone();
		if (this.old_d_record!=null) c.old_d_record = (EnterpriseCalendar) this.old_d_record.clone();
		//
		return c;
	}


	/**
	 * Standard implementation of update method
	 * @param updateType operation to execute
	 * @param dbs DatabaseStatement that perform operation
	 * @return number of update rows or new autoincrement id
	 * @throws SQLException if there is an error in your query
	 */
	public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {
		SqlWriter sql = new SqlWriter();
		sql.setTables(NAME);
		if (updateType == INSERT) {
			sql.addValue("n_protocol"			, sql.fNum(this.protocol));
			sql.addValue("v_name"			, sql.fStr(this.name));
			sql.addValue("v_server_version"			, sql.fStr(this.serverVersion));
			sql.addValue("d_record"			, (this.record==null?Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())):Query.toSQLDateTime(dbs.getDBMS(), this.record)));
			int _retval = dbs.execute(sql.costruisciInsert());
			return _retval;

		} else if (updateType == UPDATE) {
			sql.addColumnSET("v_name"			, sql.fStr(this.name));
			sql.addColumnSET("v_server_version"			, sql.fStr(this.serverVersion));
			sql.addColumnSET("d_record"			, (this.record==null || this.record.equals(this.old_d_record)?Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS())):Query.toSQLDateTime(dbs.getDBMS(), this.record)));
			sql.addWhere("n_protocol = " +sql.fNum(this.protocol));
			return dbs.execute(sql.costruisciUpdate());

		} else if (updateType == DELETE) {
			sql.addWhere("n_protocol = " +sql.fNum(this.protocol));
			return dbs.execute(sql.costruisciDelete());
		}
		return 0;
	}
	
	protected void readRow(ResultSet rs) throws SQLException {
		setProtocol(SqlWriter.getInteger(rs, "n_protocol"));
		// -------
		setName(rs.getString("v_name"));
		setServerVersion(rs.getString("v_server_version"));
		setRecord(EnterpriseCalendar.newInstance(rs.getTimestamp("d_record")));
		this.old_d_record = getRecord(); // Cache della colonna D_RECORD
	}

}
