/*
 * @(#)ClusterInfoCSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */
package it.softecspa.fileproxy.db.skins.criterias;


import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.Query;
import it.softecspa.fileproxy.db.ClusterInfo;
import it.softecspa.kahuna.sql.SqlWriter;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import org.apache.log4j.Logger;


/**
 * Abstract criteria filter for table T005_CLUSTER_INFO
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class ClusterInfoCSkin {


	protected Logger log = Logger.getLogger(getClass());

	protected ConnectionManager cm;

	// V_HOSTNAME - VARCHAR(100) NOT NULL PK
	protected String hostname;

	// V_CONTEXT - VARCHAR(100) NOT NULL PK
	protected String context;

	// V_ADDRESS - VARCHAR(20) nullable
	protected String address;

	// V_BACKPLANE_HOSTNAME - VARCHAR(100) nullable
	protected String backplaneHostname;

	// D_LIFE_START - DATETIME NOT NULL
	// protected EnterpriseCalendar lifeStart;

	// D_LIFE_STOP - DATETIME nullable
	// protected EnterpriseCalendar lifeStop;

	// D_LAST_BEAT - DATETIME NOT NULL
	// protected EnterpriseCalendar lastBeat;

	// F_DO_NOT_USE - BIT NOT NULL
	protected Boolean doNotUse;

	// V_VERSION - VARCHAR(50) nullable
	protected String version;

	protected String custom_order_by;
	protected String custom_add_where;
	protected String custom_add_options;


	protected ClusterInfoCSkin(ConnectionManager cm) {
		super();
		this.cm = cm;
	}


	public String getHostname() {
		return this.hostname;
	}

	public void setHostname(String value) {
		this.hostname = value;
	}


	public String getContext() {
		return this.context;
	}

	public void setContext(String value) {
		this.context = value;
	}


	public String getAddress() {
		return this.address;
	}

	public void setAddress(String value) {
		this.address = value;
	}


	public String getBackplaneHostname() {
		return this.backplaneHostname;
	}

	public void setBackplaneHostname(String value) {
		this.backplaneHostname = value;
	}


	public Boolean getDoNotUse() {
		return this.doNotUse;
	}

	public void setDoNotUse(Boolean value) {
		this.doNotUse = value;
	}


	public String getVersion() {
		return this.version;
	}

	public void setVersion(String value) {
		this.version = value;
	}


	/**
	 * ORDER BY condition
	 */
	public void orderBy(String value) {
		this.custom_order_by = value;
	}

	/**
	 * Custom WHERE condition to add in query composition
	 */
	public void addCustomWhere(String value) {
		this.custom_add_where = value;
	}

	/**
	 * Custom option to add in query composition
	 */
	public void addCustomOptions(String value) {
		this.custom_add_options = value;
	}



	public ConnectionManager getConnectionManager() {
		return this.cm;
	}

	/**
	 * Columns used in select with alias
	 */
	protected String getColumns(String alias) {
		return alias+".v_hostname" +
		  ", "+alias+".v_context" +
		  ", "+alias+".v_address" +
		  ", "+alias+".v_backplane_hostname" +
		  ", "+alias+".d_life_start" +
		  ", "+alias+".d_life_stop" +
		  ", "+alias+".d_last_beat" +
		  ", "+alias+".f_do_not_use" +
		  ", "+alias+".v_version" +
		  ", "+alias+".d_record";
	}

	/**
	 * Build select * using alias
	 */
	protected SqlWriter getSelectAll(String alias) {
		SqlWriter sql = new SqlWriter();
		sql.setColumns(getColumns(alias));
		sql.setTables(ClusterInfo.NAME +" "+ alias);
		return sql;
	}

	/**
	 * Build select * with filter with standard alias 't'
	 */
	protected SqlWriter getSelect() {
		return getSelect("t");
	}

	/**
	 * Build select * with filter using custom alias
	 */
	protected SqlWriter getSelect(String alias) {
		SqlWriter sql = getSelectAll(alias);
		if (this.hostname != null)			 sql.addWhere(alias+".v_hostname = "+ sql.fStr(this.hostname));
		if (this.context != null)			 sql.addWhere(alias+".v_context = "+ sql.fStr(this.context));
		if (this.address != null)			 sql.addWhere(alias+".v_address = "+ sql.fStr(this.address));
		if (this.backplaneHostname != null)			 sql.addWhere(alias+".v_backplane_hostname = "+ sql.fStr(this.backplaneHostname));
		// No query condition set for column D_LIFE_START
		// No query condition set for column D_LIFE_STOP
		// No query condition set for column D_LAST_BEAT
		if (this.doNotUse != null)			 sql.addWhere(alias+".f_do_not_use = "+ sql.fNum(this.doNotUse!=null?(this.doNotUse.booleanValue()?1:0):null));
		if (this.version != null)			 sql.addWhere(alias+".v_version = "+ sql.fStr(this.version));

		// Custom WHERE
		if (this.custom_add_where!=null) sql.addWhere(this.custom_add_where);
		// Custom OPTIONS
		if (this.custom_add_options!=null) sql.addOption(this.custom_add_options);
		// Custom ORDER_BY
		if (this.custom_order_by!=null) sql.addOption("ORDER BY "+this.custom_order_by);

		return sql;
	}


}
