/*
 * @(#)LogCSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */
package it.softecspa.fileproxy.db.skins.criterias;


import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.fileproxy.db.Log;
import it.softecspa.kahuna.sql.SqlWriter;

import org.apache.log4j.Logger;


/**
 * Abstract criteria filter for table T000_LOG
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class LogCSkin {


	protected Logger log = Logger.getLogger(getClass());

	protected ConnectionManager cm;

	// ID - INT(10) NOT NULL PK autoincrement
	protected Integer id;

	// V_SOURCE - VARCHAR(50) NOT NULL
	protected String source;

	// V_MESSAGE - TEXT(65535) NOT NULL
	protected String message;

	// V_STACKTRACE - TEXT(65535) nullable
	protected String stacktrace;

	// N_TICKET - INT(10) nullable
	protected Integer ticket;

	protected String custom_order_by;
	protected String custom_add_where;
	protected String custom_add_options;


	protected LogCSkin(ConnectionManager cm) {
		super();
		this.cm = cm;
	}


	public Integer getId() {
		return this.id;
	}

	public void setId(Integer value) {
		this.id = value;
	}


	public String getSource() {
		return this.source;
	}

	public void setSource(String value) {
		this.source = value;
	}


	public String getMessage() {
		return this.message;
	}

	public void setMessage(String value) {
		this.message = value;
	}


	public String getStacktrace() {
		return this.stacktrace;
	}

	public void setStacktrace(String value) {
		this.stacktrace = value;
	}


	public Integer getTicket() {
		return this.ticket;
	}

	public void setTicket(Integer value) {
		this.ticket = value;
	}


	/**
	 * ORDER BY condition
	 */
	public void orderBy(String value) {
		this.custom_order_by = value;
	}

	/**
	 * Custom WHERE condition to add in query composition
	 */
	public void addCustomWhere(String value) {
		this.custom_add_where = value;
	}

	/**
	 * Custom option to add in query composition
	 */
	public void addCustomOptions(String value) {
		this.custom_add_options = value;
	}



	public ConnectionManager getConnectionManager() {
		return this.cm;
	}

	/**
	 * Columns used in select with alias
	 */
	protected String getColumns(String alias) {
		return alias+".id" +
		  ", "+alias+".v_source" +
		  ", "+alias+".v_message" +
		  ", "+alias+".v_stacktrace" +
		  ", "+alias+".n_ticket" +
		  ", "+alias+".d_record";
	}

	/**
	 * Build select * using alias
	 */
	protected SqlWriter getSelectAll(String alias) {
		SqlWriter sql = new SqlWriter();
		sql.setColumns(getColumns(alias));
		sql.setTables(Log.NAME +" "+ alias);
		return sql;
	}

	/**
	 * Build select * with filter with standard alias 't'
	 */
	protected SqlWriter getSelect() {
		return getSelect("t");
	}

	/**
	 * Build select * with filter using custom alias
	 */
	protected SqlWriter getSelect(String alias) {
		SqlWriter sql = getSelectAll(alias);
		if (this.id != null)			 sql.addWhere(alias+".id = "+ sql.fNum(this.id));
		if (this.source != null)			 sql.addWhere(alias+".v_source = "+ sql.fStr(this.source));
		if (this.message != null)			 sql.addWhere(alias+".v_message = "+ sql.fStr(this.message));
		if (this.stacktrace != null)			 sql.addWhere(alias+".v_stacktrace = "+ sql.fStr(this.stacktrace));
		if (this.ticket != null)			 sql.addWhere(alias+".n_ticket = "+ sql.fNum(this.ticket));

		// Custom WHERE
		if (this.custom_add_where!=null) sql.addWhere(this.custom_add_where);
		// Custom OPTIONS
		if (this.custom_add_options!=null) sql.addOption(this.custom_add_options);
		// Custom ORDER_BY
		if (this.custom_order_by!=null) sql.addOption("ORDER BY "+this.custom_order_by);

		return sql;
	}

	/**
	 * Build select MAX for recover id
	 */
	public static Integer getMaxId(DatabaseStatement dbs) throws java.sql.SQLException {
		SqlWriter sql = new SqlWriter();
		sql.setColumns("MAX(id)");
		sql.setTables(Log.NAME);
		return new Integer(dbs.getInt(sql.costruisciSelect()));
	}


}
