/*
 * @(#)ProtocolCSkin.java	1.7.1,126 custom	2014-06-22T22:00:00Z UTC
 * Built automatically by REVERSER
 */
package it.softecspa.fileproxy.db.skins.criterias;


import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.fileproxy.db.Protocol;
import it.softecspa.kahuna.sql.SqlWriter;

import org.apache.log4j.Logger;


/**
 * Abstract criteria filter for table T015_PROTOCOL
 * Class auto generated by REVERSER, version 1.7.1,126 custom
 * 
 * Warning: this class will be rewrited from REVERSER
 * 
 * @author il Vera
 */
public abstract class ProtocolCSkin {


	protected Logger log = Logger.getLogger(getClass());

	protected ConnectionManager cm;

	// N_PROTOCOL - INT UNSIGNED(10) NOT NULL PK
	protected Integer protocol;

	// V_NAME - VARCHAR(50) NOT NULL
	protected String name;

	// V_SERVER_VERSION - VARCHAR(50) NOT NULL
	protected String serverVersion;

	protected String custom_order_by;
	protected String custom_add_where;
	protected String custom_add_options;


	protected ProtocolCSkin(ConnectionManager cm) {
		super();
		this.cm = cm;
	}


	public Integer getProtocol() {
		return this.protocol;
	}

	public void setProtocol(Integer value) {
		this.protocol = value;
	}


	public String getName() {
		return this.name;
	}

	public void setName(String value) {
		this.name = value;
	}


	public String getServerVersion() {
		return this.serverVersion;
	}

	public void setServerVersion(String value) {
		this.serverVersion = value;
	}


	/**
	 * ORDER BY condition
	 */
	public void orderBy(String value) {
		this.custom_order_by = value;
	}

	/**
	 * Custom WHERE condition to add in query composition
	 */
	public void addCustomWhere(String value) {
		this.custom_add_where = value;
	}

	/**
	 * Custom option to add in query composition
	 */
	public void addCustomOptions(String value) {
		this.custom_add_options = value;
	}



	public ConnectionManager getConnectionManager() {
		return this.cm;
	}

	/**
	 * Columns used in select with alias
	 */
	protected String getColumns(String alias) {
		return alias+".n_protocol" +
		  ", "+alias+".v_name" +
		  ", "+alias+".v_server_version" +
		  ", "+alias+".d_record";
	}

	/**
	 * Build select * using alias
	 */
	protected SqlWriter getSelectAll(String alias) {
		SqlWriter sql = new SqlWriter();
		sql.setColumns(getColumns(alias));
		sql.setTables(Protocol.NAME +" "+ alias);
		return sql;
	}

	/**
	 * Build select * with filter with standard alias 't'
	 */
	protected SqlWriter getSelect() {
		return getSelect("t");
	}

	/**
	 * Build select * with filter using custom alias
	 */
	protected SqlWriter getSelect(String alias) {
		SqlWriter sql = getSelectAll(alias);
		if (this.protocol != null)			 sql.addWhere(alias+".n_protocol = "+ sql.fNum(this.protocol));
		if (this.name != null)			 sql.addWhere(alias+".v_name = "+ sql.fStr(this.name));
		if (this.serverVersion != null)			 sql.addWhere(alias+".v_server_version = "+ sql.fStr(this.serverVersion));

		// Custom WHERE
		if (this.custom_add_where!=null) sql.addWhere(this.custom_add_where);
		// Custom OPTIONS
		if (this.custom_add_options!=null) sql.addOption(this.custom_add_options);
		// Custom ORDER_BY
		if (this.custom_order_by!=null) sql.addOption("ORDER BY "+this.custom_order_by);

		return sql;
	}

	/**
	 * Build select MAX for recover id
	 */
	public static Integer getMaxId(DatabaseStatement dbs) throws java.sql.SQLException {
		SqlWriter sql = new SqlWriter();
		sql.setColumns("MAX(n_protocol)");
		sql.setTables(Protocol.NAME);
		return new Integer(dbs.getInt(sql.costruisciSelect()));
	}


}
