package it.softecspa.fileproxy.proxyservices;

import it.softecspa.fileproxy.proxyservices.core.HttpFileProxyServiceInterfaceServlet;
import it.softecspa.fileproxy.proxyservices.manager.DeleteManager;
import it.softecspa.fileproxy.proxyservices.manager.DownloadManager;
import it.softecspa.fileproxy.proxyservices.manager.ListManager;
import it.softecspa.fileproxy.proxyservices.manager.MakeFolderManager;
import it.softecspa.fileproxy.proxyservices.manager.UploadManager;
import it.softecspa.fileproxy.proxyservices.request.DeleteRequestType;
import it.softecspa.fileproxy.proxyservices.request.DownloadRequestType;
import it.softecspa.fileproxy.proxyservices.request.ListRequestType;
import it.softecspa.fileproxy.proxyservices.request.MakeFolderRequestType;
import it.softecspa.fileproxy.proxyservices.request.UploadRequestType;
import it.softecspa.fileproxy.proxyservices.response.DeleteResponseType;
import it.softecspa.fileproxy.proxyservices.response.DownloadResponseType;
import it.softecspa.fileproxy.proxyservices.response.ListResponseType;
import it.softecspa.fileproxy.proxyservices.response.MakeFolderResponseType;
import it.softecspa.fileproxy.proxyservices.response.UploadResponseType;

import javax.servlet.ServletConfig;


@SuppressWarnings({ "serial" })
public class HttpFileProxyService extends HttpFileProxyServiceInterfaceServlet {
	
	
	@Override
	protected void afterStart(Configurable myConfig, ServletConfig config) {
		/* Nessuna operazione */		
	}
	
	@Override
	protected void beforeDestroy() {
		/* Nessuna operazione */
	}
	
	
	/**
	 * Upload file in streaming
	 * @param _request
	 * @return
	 */
	public UploadResponseType upload(UploadRequestType _request) {
		UploadManager service = new UploadManager();
		return service.process(_request);
	}
	
	
	/**
	 * Cancellazione di un file per nome
	 * @param _request
	 * @return
	 */
	public DeleteResponseType delete(DeleteRequestType _request) {
		DeleteManager service = new DeleteManager();
		return service.process(_request);
	}
	
	
	/**
	 * Lista dei file o cartelle di un percorso
	 * @param _request
	 * @return
	 */
	public ListResponseType list(ListRequestType _request) {
		ListManager service = new ListManager();
		return service.process(_request);
	}
	
	
	
	/**
	 * Cancellazione di un file per nome
	 * @param _request
	 * @return
	 */
	public DownloadResponseType download(DownloadRequestType _request) {
		DownloadManager service = new DownloadManager();
		return service.process(_request);
	}
	
	
	
	/**
	 * Creazione di una cartella
	 * @param _request
	 * @return
	 */
	public MakeFolderResponseType makeFolder(MakeFolderRequestType _request) {
		MakeFolderManager service = new MakeFolderManager();
		return service.process(_request);
	}
	
}
