package it.softecspa.fileproxy.proxyservices.core;

import it.softecspa.fileproxy.services.common.core.ModeRequest;
import it.softecspa.fileproxy.services.common.core.UniversalStatementHttpServlet;
import it.softecspa.fileproxy.services.common.core.response.body.ErrorBodyXML;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SuppressWarnings("serial")
public abstract class HttpFileProxyServiceInterfaceServlet extends UniversalStatementHttpServlet<GlobalHttpProxyRequest, GlobalHttpProxyResponse> {
	
	
	@Override
	protected void configure(Configurable myConfig) {
		myConfig.setHeaderPrefix("X-");
		myConfig.setRequestMode(ModeRequest.HEADER_OR_PARAMETER);
		myConfig.setUseResult(false);
		myConfig.setErrorBody(new ErrorBodyXML());
	}
	
	protected void doGet(HttpServletRequest request, HttpServletResponse response) {
		doStatement(request, response);
		/*
		// Nessuna richiesta evasa, restituisco la risposta standard		
		doDummy(request, response, ResponseOutcome.PS_NOT_VALID_METHOD_GET);
		return;		
		*/
	}
	
	
	protected void doPost(HttpServletRequest request, HttpServletResponse response) {
		doStatement(request, response);
	}
	
}
