package it.softecspa.fileproxy.proxyservices.manager;

import it.softecspa.fileproxy.proxyservices.manager.core.WorkflowSession;
import it.softecspa.fileproxy.proxyservices.request.AbstractHttpFileProxyRequest;
import it.softecspa.fileproxy.proxyservices.response.AbstractHttpFileProxyResponse;
import it.softecspa.fileproxy.services.ServerCacheFactory;
import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.core.UniversalManager;


public abstract class AbstractHttpFileProxyManager<I extends AbstractHttpFileProxyRequest, O extends AbstractHttpFileProxyResponse> extends UniversalManager <I,O,WorkflowSession<I>> {
	
	
	@Override
	protected void initialize() throws ManagerException {
		/* Nessuna operazione */
	}
	
	
	@Override
	protected WorkflowSession<I> buildAndValidateSession(ServerCacheFactory cacheInfo, boolean stageMode) throws CheckerException, ManagerException {
		
		// Creo l'istanza dell'oggetto di sessione DM
		session = new WorkflowSession<I>(cacheInfo, request, true, cmReadonly);
		
		session.validate();
		return session;

	}
	
	/**
	 * Normalizza il percorso passato come parametro
	 * @param value
	 * @return
	 */
	protected String normalizePath(String value) {
		String _path; 
		if (value!=null) {
			_path = value;
		} else {
			// se il parametro path non  passato, parto dalla ROOT configurata
			_path = "";
		}
		// Tolgo un eventuale primo /
		if (!_path.startsWith("/")) _path = "/"+_path;
		
		// Concateno con la base
		return ServerCacheFactory.getInstance().getResourceRoot() + _path;
	}
	
	
	/**
	 * Controlla la presenza di caratteri speciali non accettati dai path
	 * @param da_controllare
	 * @throws CheckerException
	 */
	protected void checkWildecard(String da_controllare) throws CheckerException {
		if (da_controllare==null) return;
		
		if (da_controllare.contains("..")) {
			throw new CheckerException(ResponseOutcome.FOUND_NOT_VALID_CHAR, "..");
		}
		if (da_controllare.contains("*")) {
			throw new CheckerException(ResponseOutcome.FOUND_NOT_VALID_CHAR, "*");
		}
		if (da_controllare.contains("!")) {
			throw new CheckerException(ResponseOutcome.FOUND_NOT_VALID_CHAR, "!");
		}
		if (da_controllare.contains("?")) {
			throw new CheckerException(ResponseOutcome.FOUND_NOT_VALID_CHAR, "?");
		}
		
	}
	
	
	
	@Override
	protected void completeWithSuccess(boolean stage) throws ManagerException {
		/* Nessuna operazione */
	}
	
	@Override
	protected void checkAndTraceCheckerExceptionErrorIfExist(CheckerException e) {
		/* Nessuna operazione */
	}
	
	
}
