package it.softecspa.fileproxy.proxyservices.manager;

import it.softecspa.fileproxy.proxyservices.request.DeleteRequestType;
import it.softecspa.fileproxy.proxyservices.response.DeleteResponseType;
import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.kahuna.io.File;

public class DeleteManager extends AbstractHttpFileProxyManager<DeleteRequestType, DeleteResponseType> {

	private File file_to_delete;

	@Override
	protected void validateRequest() throws CheckerException, ManagerException {
				
		// Non si possono cancellare le cartelle
		checkRequestMandatory("fileName");
		checkWildecard(request.getPath());
		String path = normalizePath(request.getPath());
		
		checkWildecard(request.getFileName());
		file_to_delete = new File (path, request.getFileName());
		if (!file_to_delete.exists()) {
			log.warn("File do not exist: '"+file_to_delete.getAbsolutePath()+"'");
			throw new CheckerException(ResponseOutcome.FILE_NOT_EXIST);
		}
		
		if (file_to_delete.isDirectory()) {
			log.warn("Error deleting file '"+file_to_delete.getAbsolutePath()+"', is a directory");
			throw new CheckerException(ResponseOutcome.FILE_IS_DIRECTORY);
		}
		
	}

	@Override
	protected void doService(DeleteRequestType request, DeleteResponseType response) throws ManagerException {
		
		if (!file_to_delete.delete()) {
			log.error("Error deleting file '"+file_to_delete.getAbsolutePath()+"'");
			throw new ManagerException(new CheckerException(ResponseOutcome.ERROR_DELETING_FILE));
		}
		log.info("File '"+file_to_delete.getAbsolutePath()+"' deleted!");
		
		// Risposta POSITIVA
		new ResponseBuilder(response).setReturn(ResponseOutcome.OK);
	}

	
}
