package it.softecspa.fileproxy.proxyservices.manager;

import it.softecspa.fileproxy.proxyservices.request.DownloadRequestType;
import it.softecspa.fileproxy.proxyservices.response.DownloadResponseType;
import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.core.response.body.BodyFileAttach;
import it.softecspa.kahuna.io.File;

public class DownloadManager extends AbstractHttpFileProxyManager<DownloadRequestType, DownloadResponseType> {

	private File file_to_download;
	
	
	@Override
	protected void validateRequest() throws CheckerException, ManagerException {
		
		// Non si possono scaricare le cartelle
		checkRequestMandatory("fileName");
		String path = normalizePath(request.getPath());
		checkWildecard(request.getPath());
		
		checkRequestIfNullSetDefault("chunk", 0);
		checkRequestIfNullSetDefault("inline", Boolean.FALSE);
		
		checkWildecard(request.getFileName());
		file_to_download = new File (path, request.getFileName());
		if (!file_to_download.exists()) {
			log.warn("File do not exist: '"+file_to_download.getAbsolutePath()+"'");
			throw new CheckerException(ResponseOutcome.FILE_NOT_EXIST);
		}
		
		if (file_to_download.isDirectory()) {
			log.warn("Error deleting file '"+file_to_download.getAbsolutePath()+"', is a directory");
			throw new CheckerException(ResponseOutcome.FILE_IS_DIRECTORY);
		}
		
	}

	@Override
	protected void doService(DownloadRequestType request, DownloadResponseType response) throws ManagerException {
		log.info("Request DOWNLOAD file '"+file_to_download.getAbsolutePath()+"' "+(request.getInline()?" (inline)":"") + (request.getChunk()>0?" (chunked:"+request.getChunk()+")":""));
				
		BodyFileAttach attach = new BodyFileAttach(file_to_download, request.getInline(), request.getChunk());
		response.addBody(attach);
		
		// Risposta POSITIVA
		new ResponseBuilder(response).setReturn(ResponseOutcome.OK);
	}

	
}
