package it.softecspa.fileproxy.proxyservices.manager;


import it.softecspa.fileproxy.proxyservices.request.ListRequestType;
import it.softecspa.fileproxy.proxyservices.response.ListResponseType;
import it.softecspa.fileproxy.proxyservices.xml.output.list.FileElement;
import it.softecspa.fileproxy.proxyservices.xml.output.list.ResponseROOT;
import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.core.response.body.BodyXML;
import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.io.UnsupportedEncodingException;
import java.util.List;

public class ListManager extends AbstractHttpFileProxyManager<ListRequestType, ListResponseType> {

	private String path;

	@Override
	protected void validateRequest() throws CheckerException, ManagerException {
		
		checkRequestIfNullSetDefault("onlyFile", Boolean.FALSE);
		checkRequestIfNullSetDefault("showHidden", Boolean.FALSE);
		checkWildecard(request.getPath());
		
		path = normalizePath(request.getPath());
	}

	
	
	@Override
	protected void doService(ListRequestType request, ListResponseType response) throws ManagerException {
		log.info("Request LIST of folder '"+path+"' (onlyFile="+request.getOnlyFile().booleanValue()+")");
		
		List<File> files = File.dir(path, request.getOnlyFile().booleanValue());
		if (files==null) {
			throw new ManagerException(new CheckerException(ResponseOutcome.PATH_NOT_VALID));
		}
		
		ResponseROOT xml_response = new ResponseROOT();
		// PATH
		xml_response.setPath(request.getPath());
		// FILES
		for (File file : files) {
			if (file.isHidden()) {
				if (!request.getShowHidden().booleanValue()) continue;
			}
			
			FileElement fe = new FileElement();
			if (file.isDirectory()) fe.setDirectory(true);
			if (file.isFile()) fe.setFile(true);
			if (file.isHidden()) fe.setHidden(true);
			fe.setSize(file.length());
			//
			EnterpriseCalendar modify = EnterpriseCalendar.newInstance(file.lastModified());
			if (modify!=null) fe.setModify(modify.formatISO8601zulu());
			//
			fe.setEntityValue(file.getName());
			xml_response.addFile(fe);
		}
		// NUMBER
		xml_response.setNumber(xml_response.getFiles().size());
		
		
		
		xml_response.applyCData();
		// Converto XmlElement in un byte[]
		byte[] xml;
		try {
			xml = xml_response.generateXML("UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new ManagerException(e);			
		}
		response.addBody(new BodyXML(xml));
		
		
		// Risposta POSITIVA
		new ResponseBuilder(response).setReturn(ResponseOutcome.OK);
	}

	
}
