package it.softecspa.fileproxy.proxyservices.manager;

import it.softecspa.fileproxy.proxyservices.request.MakeFolderRequestType;
import it.softecspa.fileproxy.proxyservices.response.MakeFolderResponseType;
import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.kahuna.io.File;

public class MakeFolderManager extends AbstractHttpFileProxyManager<MakeFolderRequestType, MakeFolderResponseType> {

	private File dir_to_create;
	
	
	@Override
	protected void validateRequest() throws CheckerException, ManagerException {
		
		// Non si possono scaricare le cartelle
		checkRequestMandatory("path");
		String path = normalizePath(request.getPath());
		checkWildecard(path);
		
		dir_to_create = new File (path);
		if (dir_to_create.exists()) {
			log.warn("Directory just exist: '"+dir_to_create.getAbsolutePath()+"'");
			throw new CheckerException(ResponseOutcome.DIRECTORY_JUST_EXIST);
		}
		
		
	}

	

	@Override
	protected void doService(MakeFolderRequestType request, MakeFolderResponseType response) throws ManagerException {
		log.info("Request CREATE of folder '"+dir_to_create.getAbsolutePath()+"'");
		
		if (!dir_to_create.mkdirs()) {
			log.error("Error in create folder '"+dir_to_create.getAbsolutePath()+"'");
			throw new ManagerException(new CheckerException(ResponseOutcome.ERROR_CREATING_DIR));
		}
		
		
		// Risposta POSITIVA
		new ResponseBuilder(response).setReturn(ResponseOutcome.OK);
	}

	
}
