package it.softecspa.fileproxy.proxyservices.manager.core;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.fileproxy.proxyservices.core.GlobalHttpProxyRequest;
import it.softecspa.fileproxy.services.ServerCacheFactory;
import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.core.UniversalSession;
import it.softecspa.jwebber.bo.Utente;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.mvc.businessobject.DatabaseManager;
import it.softecspa.mvc.exceptions.AuthenticationException;

import java.sql.Connection;
import java.sql.SQLException;

public class WorkflowSession<I extends GlobalHttpProxyRequest> extends UniversalSession<I> {
	

	public WorkflowSession(ServerCacheFactory cache, I request, boolean stage, ConnectionManager cmReadonly) {
		super(cache, request, stage, cmReadonly);
	}

	@Override
	public void validate() throws ManagerException, CheckerException  {
		/*
		 * Verifico le credenziali utente passate nella request
		 */
		
		if (XString.isBlankNullTrim(request.getUsername())) {
			throw new CheckerException(ResponseOutcome.USERNAME_MANDATORY);
		}	
		if (XString.isBlankNullTrim(request.getPassword())) {
			throw new CheckerException(ResponseOutcome.PASSWORD_MANDATORY);
		}
		
		
		// Verifica credenziali su database workflow collegato
		Utente utente = new Utente();
		utente.setUserName(request.getUsername());
		try {
			utente.setPassword(request.getPassword());
		} catch (Exception e) {
			throw new ManagerException("Error encoding password",e);
		}
		
		
		
		Connection connection = null;
		try {
			connection = DatabaseManager.getInstance().getConnection();
			utente.login(connection);
		} catch (SQLException e) {
			throw new ManagerException(e);
		} catch (AuthenticationException e) {
			log.error("Error check credential with username '"+request.getUsername()+"': "+e.getMessage());
			// Username/Password non validi
			throw new CheckerException(ResponseOutcome.USER_PASSWORD_NO_VALID);
		} catch (Exception e) {
			log.error("Error in check user checking",e);
			throw new CheckerException(ResponseOutcome.USER_NOT_VERIFY_RETRY);
		} finally {
			DatabaseManager.closeConnection(connection);				
		}
		
		/*
		 * Eliminato per velocizzare la richiesta
		 * E' fatta solo la verifica del'utente
		Parameters parameters = Parameters.getInstance();
		
		if (!utente.hasPolicy(parameters.get("POL_SA","SA")) && 
			!utente.hasPolicy(parameters.get("POL_UP_DOWN","UP_DOWN"))) {
			// Utente con polici non valida
			log.error("Not valid policy for username '"+request.getUsername()+"'");
			throw new CheckerException(ResponseOutcome.USER_POLICY_NO_VALID);
		}
		*/
		
		
		
	}

	

	
}
