package it.softecspa.fileproxy.proxyservices.request;


import it.softecspa.fileproxy.proxyservices.core.GlobalHttpProxyRequest;
import it.softecspa.fileproxy.services.common.comunicator.http.HttpRemote;
import it.softecspa.fileproxy.services.common.core.request.Protocollo;
import it.softecspa.fileproxy.services.common.core.request.RemoteHostRequestInfo;
import it.softecspa.fileproxy.services.common.core.request.TrackRequestCustomInfo;


public abstract class AbstractHttpFileProxyRequest implements GlobalHttpProxyRequest, RemoteHostRequestInfo, /*TrackRequestInfo*/ TrackRequestCustomInfo {
		
	// UniversalRequest
	private String language;
	private Protocollo protocolVersion; 
	
	// RemoteHostRequestInfo
	private HttpRemote remote;
	
	// TrackRequestInfo
	private boolean traceRequestInfo;
		
	// GlobalHttpProxyRequest
	private String username;
	private String password;
	

	@Override
	public String getUsername() {
		return username;
	}

	@Override
	public void setUsername(String username) {
		this.username = username;
	}

	@Override
	public String getPassword() {
		return password;
	}

	@Override
	public void setPassword(String password) {
		this.password = password;
	}

	
	
	
	@Override
	public Protocollo getProtocolVersion() {
		return this.protocolVersion;
	}

	@Override
	public void setProtocolVersion(Protocollo value) {
		this.protocolVersion = value;
	}

	@Override
	public String getLanguage() {
		return language;
	}

	@Override
	public void setLanguage(String value) {
		if (value!=null) {
			this.language = value.toUpperCase();
			if (this.language.length()>2) {
				// 2012-07-21 - Workaround per Engine che passano il valore in modo non corretto
				this.language = this.language.substring(0,2);
			}
		} 		
	}
	
	
	@Override
	public HttpRemote takeHttpRemote() {
		return remote;
	}

	@Override
	public void putHttpRemote(HttpRemote value) {
		this.remote = value;
	}
	
	
	@Override
	public boolean isTrackRequestInfo() {
		return traceRequestInfo;
	}

	@Override
	public void trackRequestInfo(boolean value) {
		traceRequestInfo = value;
	}

	
	

}
