package it.softecspa.fileproxy.proxyservices.request;

import it.softecspa.fileproxy.services.common.core.request.InputStreamReaderXML;
import it.softecspa.fileproxy.services.common.core.request.MethodPostMandatory;
import it.softecspa.fileproxy.services.common.core.response.Entry;
import it.softecspa.kahuna.util.xml.XmlRoot;

import java.io.InputStream;

public class UploadRequestType extends AbstractHttpFileProxyRequest implements InputStreamReaderXML<XmlRoot>, MethodPostMandatory {

	private Boolean overwrite;
	private Boolean append;
	
	private String path;
	private String fileName;

	private String encoding;
	private Integer bufferLength;


	// InputStreamReaderXML
	private InputStream inputStream;
	private XmlRoot document;
	
	@Override
	public void putInputStream(InputStream inputStream) {
		this.inputStream = inputStream;		
	}

	@Override
	public InputStream takeInputStream() {
		return inputStream;
	}

	@Override
	public XmlRoot takeBufferedInputDocument() {
		return document;
	}

	@Override
	public void bufferizeInputDocument(XmlRoot inputDocument) {
		this.document = inputDocument;
	}

	public Boolean getOverwrite() {
		return overwrite;
	}

	public void setOverwrite(Boolean override) {
		this.overwrite = override;
	}

	
	
	public String getFileName() {
		return fileName;
	}

	public void setFileName(String filename) {
		this.fileName = filename;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getEncoding() {
		return encoding;
	}

	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	public Integer getBufferLength() {
		return bufferLength;
	}

	public void setBufferLength(Integer bufferLength) {
		this.bufferLength = bufferLength;
	}

	public Boolean getAppend() {
		return append;
	}

	public void setAppend(Boolean append) {
		this.append = append;
	}

	@Override
	public Entry[] takeCustomEntry() {
		return new Entry[] { new Entry("username", getUsername())
						   , new Entry("path", getPath())
						   , new Entry("filename", getFileName())
						   , new Entry("overwrite", getOverwrite())
						   , new Entry("append", getAppend())
						   , new Entry("bufferLength", getBufferLength()) 
						   , new Entry("encoding", getEncoding())
						   };
	}

}
