package it.softecspa.fileproxy.proxyservices.response;

import it.softecspa.fileproxy.proxyservices.core.GlobalHttpProxyResponse;
import it.softecspa.fileproxy.services.common.core.MyReturn;
import it.softecspa.fileproxy.services.common.core.response.body.MyBody;


public abstract class AbstractHttpFileProxyResponse implements GlobalHttpProxyResponse {

	private MyReturn myreturn;
	private MyBody body;
	
	
	@Override
	public String getReturnCode() {
		return myreturn.getCode();
	}

	@Override
	public String getReturnMessage() {
		return myreturn.getMessage();
	}


	@Override
	public void setReturn(MyReturn myreturn) {
		this.myreturn = myreturn;		
	}

	@Override
	public MyReturn takeMyReturn() {
		return this.myreturn;
	}
	
	
	@Override
	public MyBody takeBody() {
		return this.body;
	}

	@Override
	public void addBody(MyBody body) {
		this.body = body;
	}
	
	
	
}
