package it.softecspa.fileproxy.services.common;



@SuppressWarnings("serial")
public class CheckerException extends Throwable implements TraceableWithIdException {

	private String id;
	private ResponseResult result;
	
	private boolean traceLog; 
	private boolean traceErrorCall; 
	
	private String supplementaryMessage;
	
	
	public CheckerException(ResponseOutcome outcome) {
		this(outcome.getReturnCode(), outcome.getMessage(), null, ResponseResult.ERROR, outcome.isTraceLog(), outcome.isTraceErrorCall());
	}
	
	public CheckerException(ResponseOutcome outcome, ResponseResult result) {
		this(outcome.getReturnCode(), outcome.getMessage(), null, result, outcome.isTraceLog(), outcome.isTraceErrorCall());
	}
	
	public CheckerException(ResponseOutcome outcome, String supplementary) {
		this(outcome.getReturnCode(), outcome.getMessage(), supplementary, null, outcome.isTraceLog(), outcome.isTraceErrorCall());
	}
	
	public CheckerException(ResponseOutcome outcome, String supplementary , ResponseResult result) {
		this(outcome.getReturnCode(), outcome.getMessage(), supplementary, result, outcome.isTraceLog(), outcome.isTraceErrorCall());
	}
	
	private CheckerException(String id, String message, String supplementary, ResponseResult result, boolean traceLog, boolean traceErrorCall) {
		super(message);
		this.id = id;
		this.result = result;
		this.supplementaryMessage = supplementary;
		this.traceLog = traceLog;
		this.traceErrorCall = traceErrorCall;
	}
	
	
	@Override
	public String getId() {
		return id;
	}

	public ResponseResult getResult() {
		return result;
	}
	

	@Override
	/**
	 * Returns the detail and supplementary message string of this throwable.
     *
     * @return  the detail message string of this <tt>CheckerException</tt> instance.
	 */
	public String getMessage() {
		if (supplementaryMessage==null) {
			return super.getMessage();
		} else {
			return super.getMessage() +" ["+supplementaryMessage+"]";
		}
	}
	
	/**
	 * Returns the standard detail message string of this throwable.
     *
     * @return  the detail message string of this <tt>CheckerException</tt> instance.
	 */
	public String getStandardMessage() {
		return super.getMessage();
	}
	
	/**
	 * Returns the supplementary message string of this throwable.
     *
     * @return  the supplementary message string of this <tt>CheckerException</tt> instance.
     *          (which may be <tt>null</tt>).
	 */
	public String getSupplementaryMessage() {
		return supplementaryMessage;
	}

	@Override
	public String toString() {
        String s = getClass().getName();
        String message = getMessage();
        return (message != null) ? (s + ": " + message) : s;
    }

	@Override
	public boolean isTraceLog() {
		return traceLog;
	}
	
	@Override
	public boolean isTraceErrorCall() {
		return traceErrorCall;
	}
	
}
