package it.softecspa.fileproxy.services.common;

import it.softecspa.PortalSettings;
import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.fileproxy.DatabaseBalancer;
import it.softecspa.fileproxy.db.Log;
import it.softecspa.fileproxy.services.ClusterSynchronizer;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.log.Ticket;
import it.softecspa.kahuna.services.PostmanPat;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;
import it.softecspa.portal.Parameters;

import java.sql.SQLException;
import java.util.Calendar;

import org.apache.log4j.Logger;

@SuppressWarnings("serial")
public class EnterpriseLog extends Throwable {

	private Logger log = Logger.getLogger(getClass());
	private final int LOG_LIFE = 30;
	
	
	public EnterpriseLog(String message, Throwable e) {
		super(message, e);		
	}
	
	public EnterpriseLog(String message) {
		super(message);		
	}
	
	public EnterpriseLog(Throwable e) {
		super(e);
	}

	
	public int write() {
		return write(ClusterSynchronizer.getInstance().getPublicHostName(), DatabaseBalancer.getInstance().getStage(), null);
	}
	
	
	public int write(String source) {
		return write(source, DatabaseBalancer.getInstance().getStage(), null);
	}
	
	/*
	public int write(String source, ConnectionManager cm) {
		return write(source, cm, null);
	}
	*/
	
	/*
	public int write(String source, Integer ticket) {
		return write(source, DatabaseBalancer.getInstance().getStage(), ticket);
	}
	*/
	
	/**
	 * Scrive l'errore su database nella tabella dei log
	 * @param source
	 * @param cm
	 * @param ticket
	 * @return
	 */
	private int write(String source, ConnectionManager cm, Integer ticket) {
		try {
			String message = getMessage();
	        if (ticket==null) ticket = Ticket.generaTicket();
	        
			try {
				
				// Metto una traccia nel log
				log.error("Traced error on database log with ticket #"+ticket +"\n" + 
						  ">> "+ (message != null ? message : toString()), (this.getCause()!=null?this.getCause():null));
				//
				Log elog = new Log();
				elog.setSource(source);
				elog.setMessage(message != null ? message : toString());
				elog.setTicket(ticket);
				if (this.getCause()!=null) elog.setStacktrace(stringStackTrace(this.getCause()));
				elog.insert(cm);
				
				// Cancella tutti gli errori pi vecchi di 30 giorni
				EnterpriseCalendar before = EnterpriseCalendar.now();
				before.add(Calendar.DAY_OF_MONTH, -LOG_LIFE);
				flushBefore(cm, before);
				
				
			} catch (SQLException e) {
				log.fatal("Unhandled SQLException writing error on database log",e);
			
			} catch (Exception e) {
				log.fatal("Unhandled Exception writing error on database log",e);
			
			} catch (Error e) {
				log.fatal("Unhandled Error writing error on database log",e);
			}
						
			return ticket;
		} catch (Exception e) {
			Logger.getLogger(EnterpriseLog.class).fatal("Very unhandled exception",e);
			return -1;
		}
	}

	
	/**
	 * Invia una mail al gestore del servizio con la segnalazione
	 */
	public void sendEmail() {
		sendEmail("Exception");
	}		
	
	/**
	 * Invia una mail al gestore del servizio con la segnalazione
	 * impostando il subject
	 */
	public void sendEmail(String subject) {
		sendEmail(PortalSettings.MAIL_ERROR_ENABLE, subject);
	}
	
	/**
	 * Invia una mail al gestore del servizio con la segnalazione
	 * impostando il subject
	 * @param param
	 * @param subject
	 */
	public void sendEmail(String param, String subject) {
		if (XString.isNotBlankNullTrim(param)) {
			Parameters parameters = Parameters.getInstance();
			if (!parameters.getBoolean(param, false)) return;
		}
		
		PostmanPat pat = new PostmanPat();
		pat.setSubject(subject);
		pat.addMessage(getMessage());
		if (getCause()!=null) {
			pat.addMessage("\n"+
						   stringStackTrace(getCause()));
		}
		//
		pat.send();
	}
	
	
	
	
	
	
	/**
	 * Cancella tutti i messaggi dal log su database
	 * @param cm
	 */
	public static void flushAll(ConnectionManager cm) {		
		try {
			Log elog = new Log();
			elog.delete(cm);
		} catch (SQLException e) {
			Logger.getLogger(EnterpriseLog.class).fatal("Impossible to delete record from "+Log.NAME, e);
		}
	}

	
	/**
	 * Cancella i messaggi pi vecchi della data indicata
	 * @param cm
	 * @param before
	 */
	public static void flushBefore(ConnectionManager cm, EnterpriseCalendar before) {
		try {
			Log elog = new Log();
			elog.setRecord(before);
			elog.deleteBefore(cm);
			
		} catch (SQLException e) {
			Logger.getLogger(EnterpriseLog.class).fatal("Impossible to delete record from "+Log.NAME, e);
		}
		
	}

	
	
	/**
	 * Provides programmatic access to the stack trace information printed by
	 * {@link #stringStackTrace()}. Returns a string of stack trace elements,
	 * each representing one stack frame.
	 * 
	 * @return a string of stack trace elements representing the stack trace
	 *         pertaining to this throwable.
	 */
	public String stringStackTrace(Throwable e) {
		String s = e.toString() + "\n";
		StackTraceElement[] trace = e.getStackTrace();
		for (int i = 0; i < trace.length; i++) {
			s += "\tat " + trace[i] + "\n";
		}
		
		if (e.getCause() != null) s += "Caused by: "+stringStackTrace(e.getCause());		
		return s;
	}

}
