package it.softecspa.fileproxy.services.common;




@SuppressWarnings("serial")
public class RemoteCallException extends Throwable {

	String id;
	
	public RemoteCallException(Throwable e) {
		super(ResponseOutcome.INTERNAL_SERVER_ERROR.getMessage(),e);
		id = ResponseOutcome.INTERNAL_SERVER_ERROR.getReturnCode();
	}
	
	
	public RemoteCallException(String message, Throwable e) {
		super(message, e);
		id = ResponseOutcome.INTERNAL_SERVER_ERROR.getReturnCode();
	}
	
	private RemoteCallException(String id, String message) {
		super(message);
		this.id = id;
	}
	
	public RemoteCallException(ResponseOutcome outcome, String add_message) {
		this(outcome.getReturnCode(), outcome.getMessage()+": "+add_message);		
	}
	
		
	public RemoteCallException(ResponseOutcome outcome, Throwable e) {
		super(outcome.getMessage(), e);
		id = outcome.getReturnCode();
	}
	
	public RemoteCallException(ResponseOutcome outcome) {
		super(outcome.getMessage());
		id = outcome.getReturnCode();
	}

	
	public String getId() {
		return id;
	}
	
	

}
