package it.softecspa.fileproxy.services.common;

public enum ResponseOutcome {
		// Esito positivo
		  OK_JUST_NOTIFIED					(0,false,false,"Ok, just notified")
		, OK								(0,false,false,"Ok")	
		, DRAFT_NO_DATA						(0,false,false,"No data found")
				
		// Errore non definito
		, ERROR								(1,"Error") 		
		
		
		// Interfacciamento con My-DesktopMate, classe 50000
		, MYDM_NOT_VALID					(50001,"XML request is not valid: 'type' unknown")
		, MYDM_CHECKING_EXCEPTION			(50002,"XML request is not consistent, verify XML")
		, MYDM_REGISTRATION_EMPTY			(50003,"XML request is not consistent, add 'registration' to XML")
				
		, MYDM_MANAGER_EXCEPTION			(50010,"Internal server error")
		, MYDM_UNHANDLED_EXCEPTION			(50011,"Internal server error (unhandled)")
		, MYDM_SQL_EXCEPTION				(50012,"Internal server error (database)")
		
		, MASTER_STATUS_NOT_VALID			(50020,"Master status operation list: 'statement' unknown")
		, MASTER_STATUS_NULL_VALUE			(50021,"Master status: node info is null")
		
		, INPUT_FORWARD_XML_NULL			(50101,"Forward XML request is null")
		, OUTPUT_FORWARD_XML_NULL			(50103,"Forward XML response is null")
		
		
		// Messaggi restituiti dalla connessione al server sso, classe 80000
		, SSO_PROVIDER_NOT_CONFIGURED		(80100,"SSO provider not configured")
		, SSO_PROVIDER_CONFIG_ERROR			(80101,"SSO provider client configuration not valid")
		, SSO_PROVIDER_CONFIG_ERROR_IO		(80102,"SSO provider client configuration error")
		
		, SSO_MOBILE_CLIENT_NOT_CONFIGURED	(80110,"SSO mobile client not configured")
		, SSO_MOBILE_CLIENT_CONFIG_ERROR	(80111,"SSO mobile client configuration not valid")
		, SSO_MOBILE_CLIENT_CONFIG_ERROR_IO	(80112,"SSO mobile client configuration error")
		, SSO_MOBILE_CLIENT_CONFIG_ERROR_FACEBOOK	(80113,"SSO mobile client configuration error: missing 'facebook.authenticator'")
		, SSO_FACEBOOK_APP_ID_NOT_FOUND		(80113,"Application configuration error: missing 'faceboob-app-id'")
		, SSO_FACEBOOK_SECRET_NOT_FOUND		(80114,"Application configuration error: missing 'facebook-secret'")
		, SSO_MOBILE_CLIENT_CONFIG_ERROR_TWITTER	(80115,"SSO mobile client configuration error: missing 'twitter.authenticator'")
		
		
		, SSO_GENERIC_ERROR					(80120,"SSO error")
		, SSO_LOGIN_ERROR					(80121,"SSO login error")
		, SSO_LOGOUT_ERROR					(80122,"SSO logout error")
		, SSO_CHANGE_PASSWORD_ERROR			(80123,"SSO change password error")
		, SSO_GET_TOKEN_INFO_ERROR			(80124,"SSO get token info error")
		, SSO_GET_USER_INFO_ERROR			(80125,"SSO get user info error")
		, SSO_WRONG_CREDENTIAL				(80126,"Wrong credential")
		, SSO_TOKEN_INFO_NULL_USERNAME		(80127,"SSO get token info without username")
		, SSO_TOKEN_INFO_NULL_ORGANIZATION	(80128,"SSO get token info without organization")
		
		
		
		// Messaggi restituiti dal servizio notifiche, classe 80000
		, SUBSCRIPTION_RENEWAL_NOT_FOUND	(80400,"Couple subscrition/renewal not found")
		, RENEWAL_NOT_FOUND					(80401,"Renewal not found for required renewal") 
		, ONESHOT_CODE_NOT_FOUND			(80402,"One-shot code not found for required renewal") 
		, ONESHOT_CODE_USED					(80403,"One-shot code already used for required renewal") 
		, ACTIVATION_DM_NOT_FOUND			(80404,"DesktopMate activation not found")		
		, ONESHOT_IMEI_NOT_MATCH			(80405,"IMEI code do not match") 
		, ONESHOT_RENEWAL_NOT_MATCH 		(80406,"Renewal code do not match")
		, STATUS_NOT_VALID_VALUE			(80407,"Not valid value for field 'status', accepted 'OK','BURN'")
		, RENEWAL_NOT_VALID_INSTANCE		(80408,"Renewal not valid, instance do not macth") 
		
	
		// Errori principale DM Server 
		, FIELD_MANDATORY					(90401,"Field is mandatory")
		, FIELD_EMPTY						(90402,"Field is empty (not valid empty string)")
		, FIELD_OUT_OF_RANGE				(90403,"Field is out of range")
		, FIELD_NOT_VALID					(90404,"Field is not valid")
		, FIELD_OVERFLOW					(90405,"Field is in overflow")
		, NO_VALID_CURRENCY 				(90406,"No valid currency value")
		, FIELD_TYPE_NOT_VALID				(90407,"Field type is not valid (cast exception)")
		, INVALID_METHOD_CHECKING			(90408,"Internal error, invalid method checking")
		, LANGUAGE_IS_MANDATORY				(90409,true,true,"Language code is mandatory")
		, CUSTOMER_NOT_VALID				(90410,true,true,"Customer is not valid")
		, CUSTOMER_CANCELLED				(90411,true,true,"Customer is not valid (cancelled)")
		, INSTANCE_IS_MANDATORY				(90412,true,true,"Instance code is mandatory")
		, INSTANCE_NOT_VALID				(90413,true,true,"Instance is not valid")
		, INSTANCE_CANCELLED				(90414,true,true,"Instance is not valid (cancelled)")
		, INSTANCE_NOT_EXIST				(90415,true,true,"Instance is not valid (not exist)")
		, TECHNOLOGY_IS_MANDATORY			(90416,true,true,"Technology code is mandatory"	)
		, CLIENTID_IS_MANDATORY				(90417,true,true,"Client id is mandatory")
		, TECHNOLOGY_NOT_EXIST				(90418,true,true,"Technology not exist")
		, TECHNOLOGY_NOT_VALID				(90419,true,true,"Technology is not valid")
		, TECHNOLOGY_CANCELLED				(90420,true,true,"Technology is not valid (cancelled)")
		, DEVICE_REGISTERED_FAULT			(90421,true,true,"Check device registered table (integrity fault)")
		, REGISTRATION_CODE_FAULT			(90422,true,true,"Check registration code table (integrity fault)")
		, REGISTRATION_CODE_NOT_FOUND		(90423,"Registration code not found")
		, REGISTRATION_CODE_LIMIT			(90424,"Registration code limit overflow")
		, REGISTRATION_CODE_NO_ZONE			(90425,"Registration code do not have valid zone code")
		, REGISTRATION_CANCELLED			(90426,"Registration code not found (cancelled)")
		, PREREG_DEVICE_NOT_ENABLED			(90427,true,true,"Preregistration failed, device id is not valid")				
		, RESOLUTION_CODE_NOT_VALID			(90428,true,true,"Display resolution code not valid")
		, RESOLUTION_CODE_NOT_FOUND			(90429,true,true,"Display resolution code not found")
		, ZONE_NOT_VALID					(90430,"Zone is not valid")
		, ZONE_CANCELLED					(90431,"Zone is not valid (cancelled)")
		, ZONE_NOT_VALID_RESTRICTION		(90432,"Zone is not valid (activation rule restriction)")
		, ZONE_CODE_IS_MANDATORY			(90433,"Parameter 'zoneCode' is mandatory")
		, CHANGE_ZONE_NOT_PERMITTED			(90434,"Change zone not permitted")		
		, PROFILE_NOT_FOUND					(90435,"Profile not found")
		, PROFILE_CANCELLED					(90436,"Profile is not valid (cancelled)")	
		, PROFILE_WITHOUT_PACKAGE			(90437,"Profile without required package association")
		, PACKAGE_NOT_FOUND					(90438,"Package not found")
		, PACKAGE_NOT_VALID					(90439,"Package not valid")
		, PACKAGE_CANCELLED					(90440,"Package is not valid (cancelled)")
		, PACKAGE_WITHOUT_SERVICE			(90441,"Package without services")
		, PACKAGE_WITH_SERVICE_CANCELLED	(90442,"Package with all service cancelled")
		, PACKAGE_ZONE_NOT_MATH				(90442,"Package not match with registration zone")
		, PACKAGE_TECHNOLOGY_NOT_ACTIVE		(90444,"No packages activated for this technology")	
		, NO_TECHNOLOGY_SCREEN_FOUND		(90445,true,true,"No technology/screen association found")
		, BACKGROUND_SIZE_CODE_NOT_VALID	(90446,"Background size code not valid")
		, BACKGROUND_SIZE_CODE_NOT_FOUND	(90447,"Background size code not found")
		, NO_TECH_SCREEN_BKG_FOUND			(90448,true,true,"No technology/screen/background association found")
		, NORMALIZED_RESOLUTION_NOT_VALID	(90449,true,true,"(Normalized) Screen resolution code not valid")
		, DEVICE_REGISTRATION_NOT_VALID		(90450,true,true,"Device is not valid, verify registration")
		, DEVICE_REGISTRATION_CANCELLED		(90451,true,true,"Device is not valid, verify registration (cancelled)")
		, DEVICE_NO_REGISTRATION			(90452,true,true,"Device is not valid, complete registration")
		, DEVICE_REGISTRATION_CODE	  		(90453,true,true,"Device is not valid, complete registration with code")		
		, DEVICE_MAX_NUMBER_REACHED			(90454,true,true,"Maximum number of devices reached")		
		, MENU_TOO_MATCH					(90455,true,true,"Found too match valid menu for the instance")
		, MENU_NONE_FOUND					(90456,"No valid menu found for the instance")	
		, MENU_ROOT_NONE_FOUND				(90457,"Menu structure is not valid, no root found")
		, MENU_NOT_VALID_STRUCTURE_ELEMENT	(90458,"Menu structure is not valid, no element found")	
		, MENU_NOT_VALID_STRUCTURE_MODULE	(90459,"Menu structure is not valid, no module found")	
		, MENU_NOT_VALID_STRUCTURE_THEME	(90460,"Menu structure is not valid, no theme found")
		, MENU_NOT_VALID_STRUCTURE_ROOT		(90461,"Menu structure is not valid, root without child")
		, MENU_NOT_VALID_STRUCTURE_SERVICE	(90462,"Menu structure is not valid, no service found in zone")	
		, MENU_NOT_VALID_STRUCTURE_IMAGE	(90463,"Menu structure is not valid, found element without image")	
		, MENU_NOT_VALID_STRUCTURE_RENDER	(90464,"Menu structure is not valid, found valid element without valid render")	
		, MENU_NOT_VALID_STRUCTURE_FATHER	(90465,"Menu structure is not valid, no father element found")	
		, MENU_NOT_VALID_STRUCTURE_APP		(90466,"Menu structure is not valid, no application found")	
		, MODULE_APPLICATION_NOT_FOUND		(90467,"Model application id is not valid, not found")	
		, REGISTRATION_CODE_NOT_LOGGED		(90468,"Registration code not valid for logged status")
		, REGISTRATION_CODE_NOT_ANONIM		(90469,"Registration code not valid for anonim status")
		, UPLOAD_NO_FILE					(90470,"No file to upload")	
		, UPLOAD_FILE_OVERWRITE_ERROR		(90471,"Upload file error; do not overwrite")	
		, UPLOAD_FILE_DUPLICATE				(90472,"Upload file error; duplicate file")	
		, UPLOAD_FILE_ERROR					(90473,"Upload file error!")	
		, UPLOAD_FILE_NOT_WRITE				(90474,"Upload file error; can not write")	
		, GROUP_CODE_NOT_VALID				(90475,true,true,"Group code is not valid")
		, GROUP_CODE_IS_MANDATORY			(90476,"Group code is mandatory")
		, GROUP_CODE_TOO_MANY				(90477,true,true,"Group code is not valid (too many records)")
		, GROUP_CODE_RECORD_NOT_FOUND		(90478,true,true,"Group code record not found")
		, CREATE_DIRECTORY_ERROR			(90479,"Error create directory")	
		, UPLOAD_RESOURCE_TYPE_NOT_VALID	(90480,"Upload resource type not valid or not managed")	
		, NOT_VALID_GALLERY_COORDINATE		(90481,"Not valid gallery coordinate")	
		, NOT_VALID_IMAGE_TYPE				(90482,"Not valid image extention for selected type")	
		, NOT_VALID_IMAGE_NOT_INFO			(90483,"Not valid image; not valid info")	
		, DUPLICATED_RESOURCE_FILE			(90484,"Duplicated resource file")	
		, NO_VALID_CREDENTIAL_FIELD			(90485,"Not found any valid credential field")
		, USER_PASSWORD_NO_VALID			(90486,"Username/password not valid")
		, USER_PASSWORD_TOO_MANY			(90487,"Username/password not valid (too many records)")
		, ROLE_NOT_VALID					(90488,"Role not valid")
		, ROLE_TOO_MANY						(90489,"Role not valid (too many records)")
		, FILE_FORMAT_NOT_VALID				(90490,"File format not valid")			
		, DRAFT_EMPTY_QUERY					(90491,"Empty query")
		, DRAFT_SQL_ERROR					(90492,"SQL error")
		, DRAFT_COLUMN_NOT_MATCH 			(90493,"Column do not match")
		, DRAFT_TYPE_NOT_VALID	 			(90494,"Draft type is not valid")
		, USER_NOT_FOUND					(90495,"User not valid (not found)")
		, REMOTE_PROFILE_FAULT				(90496,"Registration code not valid for remote profile (SSO)")
		, NO_VALID_DAY_FORMAT 				(90497,"Not valid day format: 'yyyy-MM-dd' or 'yyyyMMdd'")
		, INSTANCE_NOT_ACTIVE				(90498,true,true,"Instance is not active")
		, REMOTE_IP_RULES_NOT_VALID			(90499,true,true,"Remote ip rule not valid")
		, REMOTE_IP_RULES_TOO_MATCH			(90500,true,true,"Remote ip rule not valid, too match rules")
		, REMOTE_IP_LOCK					(90501,true,true,"Remote ip filter lock this ip")
		, OPERATOR_NO_VALID					(90502,"Operator not valid")
		, OPERATOR_TOO_MANY					(90503,"Operator not valid (too many records)")
		, NOT_VALID_FILTER_TYPE				(90504,"Not valid filter type")
		, NOT_VALID_FILTER_CONDITION		(90505,"Not valid (or unknown) filter condition type")
		, FILTER_CONDITION_MANDATORY		(90506,"Not found mandatory filter condition")
		
		
		, MALFORMD_XML_DOCUMENT				(90510,"Malformed XML document")
		, XML_ELEMENT_EMPTY					(90511,"XML element is empty")
		
		, MENU_XML_ERROR					(90513,"Error building XML menu interface")
		, THEME_XML_ERROR					(90514,"Error building XML theme interface")		
		
		, MALFORMD_JSON_DOCUMENT			(90516,"Malformed JSON document")
		
		, PROTOCOL_VERSION_MANDATORY		(90520,"Protocol version is mandatory")
		, PROTOCOL_VERSION_NOT_VALID		(90521,true,true,"Protocol version not valid")
		, PROTOCOL_VERSION_OUT_OF_RANGE		(90522,true,true,"Protocol version out of range")
			
		, UNIQUE_ID_NO_IMMUTABLE			(90530,"Any immutable data are passed, check system!")
		, UNIQUE_ID_NOT_VALID				(90531,"Client id (unique) not valid, check client process sequence")
		, DEVICEID_IS_MANDATORY				(90532,"Device id is mandatory")
		, UNIQUE_ID_TECH_DO_NOT_MATCH		(90533,"Techonology class do not match with unique client id record")
		, UNIQUE_ID_IMMUTABLE_DO_NOT_MATCH	(90534,"Immutable data do not match with unique client id record")
		, GENERATEDID_IS_MANDATORY			(90535,"Device generated id (old clientId ) is mandatory")
		, NO_VALID_IDENTIFIER				(90536,"Non valid identifier for technology!")
		, USERTOKEN_NOT_VALID				(90537,"User token not valid")
		, USERNAME_NOT_MATCH_TOKEN_INFO		(90538,"Username not match token info")
		, ORGANIZATION_NOT_MATCH_TOKEN_INFO	(90539,"Organization not match token info")
		, SESSION_LOGIN_WEB_ERROR			(90540,"Error loading session login for web")
		
		, USER_POLICY_NO_VALID				(90543,"User with not valid policy")
		, USERNAME_MANDATORY				(90544,"Username mandatory")
		, ACCESS_TOKEN_USERNAME_MANDATORY	(90545,"AccessToken or Username are mandatory")
		, PASSWORD_MANDATORY				(90546,"Password mandatory with username")
		, TOO_MANY_SSO_LOGIN				(90547,"Too many SSO-LOGIN; problem extracting addional")
		, NOT_VALID_ADDITIONAL				(90548,"Not valid additional json parameter (server)")
		
		, IMAGE_TYPE_ONLY_FOR_GENERAL		(90557,"Image type selected is valid only for general gallery")
		, THEME_ID_MUST_BE_NULL				(90558,"Theme id must be null")
		, NO_LANGUAGE_FOUND_IN_INSTANCE		(90559,"Non language found in instance, check configuration")
		, RESOURCE_DETAIL_NOT_EXIST			(90560,"Resource not exist")
		, RESOURCE_DETAIL_NOT_VALID			(90561,"Resource is not valid")
		, RESOURCE_DETAIL_CANCELLED			(90562,"Resource is not valid (cancelled)")
		, RESOURCE_DETAIL_NOT_FOUND			(90563,"Resource is not valid, file not found")		
		, THEME_NOT_VALID					(90564,true,true,"Theme is not valid")
		, THEME_CANCELLED					(90565,true,true,"Theme is not valid (cancelled)")
		, THEME_NOT_PUBLISHABLE				(90566,true,true,"Theme is not valid (not publishable)")
		, THEME_RENDERER_NOT_VALID			(90567,true,true,"Theme renderer association is not valid")
		, THEME_RENDERER_CANCELLED			(90568,true,true,"Theme renderer association is not valid (cancelled)")
		, THEME_RENDERER_TOO_MATCH			(90569,true,true,"Found too match valid theme renderer association")		
		, RENDERER_NOT_FOUND				(90570,"Renderer for menu is not found")
		, RENDERER_CANCELLED				(90571,"Renderer for menu is not found (cancelled)")
		, RENDERER_INFO_NOT_FOUND			(90572,"Renderer info for menu/screen not found")
		, RENDERER_INFO_CANCELLED			(90573,"Renderer info for menu/screen not found (cancelled)")
		, RENDERER_IMAGE_NOT_FOUND			(90574,"Renderer background image for menu/screen not found")
		, TECHNOLOGY_APPLIED_NOT_EXIST		(90575,"Instance/Technology not exist")
		, TECHNOLOGY_APPLIED_NOT_VALID		(90576,"Instance/Technology is not valid")
		, TECHNOLOGY_APPLIED_CANCELLED		(90577,"Instance/Technology is not valid (cancelled)")
		, THEME_NOT_VALID_FOR_INSTANCE		(90578,true,true,"Theme is not valid for instance")
		, RESOURCE_ID_NOT_FOUND				(90579,"Resource id not valid (not found)")
		, FEEDBACK_NOT_VALID 				(90580,"Not valid feedback XML")
		, FEEDBACK_NOT_VALID_NUMBER			(90581,"Not valid feedback value, number expected")
		, FEEDBACK_NOT_VALID_VALUE			(90582,"Not valid feedback value")
		, FEEDBACK_SERVICE_NOT_NUMBER		(90583,"Not valid service id in feedback")
		, FEEDBACK_SERVICE_NOT_FOUND		(90584,"Not found service id in feedback")
		, FEEDBACK_DATE_NOT_FOUND			(90585,"Not found data/time value")
		, FEEDBACK_DATE_NOT_VALID			(90586,"Not valid data/time value format")
		, FEEDBACK_ACTION_ID_NOT_VALID		(90587,"Feedback action id not valid in XML")
		, SERVICE_ID_NOT_VALID				(90588,"Service id is not valid")
		, SERVICE_ID_NOT_VALID_CANCELLED	(90589,"Service id is not valid (cancelled)")
		, CREDITS_ID_NUMBER_EXCEPTION		(90590,"Not valid id service for credits feedback")
		, CREDITS_LEFT_NUMBER_EXCEPTION		(90591,"Number format exception on credits left value")
		, CREDITS_USED_NUMBER_EXCEPTION		(90592,"Number format exception on credits used value")
		, SERVICE_ACTION_NOT_VALID			(90593,"Service on demand action not valid")
		, SERVICE_INSTANCE_NOT_COMPATIBLE 	(90594,"Service not compatible with instance")
		, NO_PACKAGE_FOR_SERVICE			(90595,"No package found for service")
		, NO_RENEWAL_FOR_SERVICE			(90596,"No renewal found for service")
		, SERVICE_ID_NOT_ON_DEMAND			(90597,"Service is not on demand")
		, SERVICE_ID_NOT_ON_DEMAND_CANCELLED(90598,"Service is not on demand (cancelled)")
		, SERVICE_CATEGORY_NOT_VALID		(90599,"Service/category not valid")
		// Classe 90600
		, NOTIFY_IO_EXCEPTION				(90600,"I/O error contacting url")
		, NOTIFY_URL_EXCEPTION				(90601,"Url exception")
		, NOTIFY_NOT_VALID_CONTENT_TYPE 	(90602,"Not valid response content type (text/xml)")
		, NOTIFY_NULL_RESPONSE				(90603,"Null response from remote server")
		, NOTIFY_JDOM_EXCEPTION				(90604,"JDOM exception in remote server response")
		, NOTIFY_XML_NOT_VALID				(90605,"XML is not valid in remote server response")
		, NOTIFY_XML_TAG_NOT_VALID			(90606,"XML tag is not valid in remote server response")
		, NOTIFY_NOT_FOUND					(90607,"Notify record not found in table")
		, MARKET_ID_CODE_NOT_VALID			(90608,"Market code or id non valid for the instance")
		, MARKET_ID_CODE_NOT_MATCH			(90609,"Market code and id not match the same market")
		, REMOTE_KO_HTTP_RESPONSE_CODE		(90610,"Remote server ko http response code")
		, REMOTE_UNDEFINED_RETURN			(90611,"Undefined remote return code and message")		
		, SEND_MESSAGE_XML_NULL				(90612,"Input XML request is null")
		, SEND_MESSAGE_XML_NOT_VALID		(90613,"Input XML request is not valid")
		, SEND_MESSAGE_FILTER_NULL			(90614,"Input XML request not valid; FILTER is empty")
		, SEND_MESSAGE_CORE_NULL			(90615,"Input XML request not valid; MESSAGE is empty")
		, SEND_MESSAGE_INSTANCE_NULL		(90616,"Input XML request not valid; INSTANCE-CODE or GROUP-CODE is mandatory")
		, SEND_MESSAGE_INSTANCE_NOT_VALID	(90617,"Input XML request not valid; INSTANCE-CODE not valid")
		, MESSAGE_CHANNEL_NOT_VALID			(90620,"Push message channel not valid")
		, MESSAGE_CHANNEL_CANCELLED			(90621,"Push message channel not valid (cancelled)")
		, MESSAGE_CHANNEL_NOT_MANAGED		(90622,"Push message channel cathegory not managed")
		, MESSAGE_IS_TOO_LONG				(90623,"Push message is too long")
		, MESSAGE_ADVANCED_TARGET_NULL		(90624,"Push message target for statement is null")
		, MESSAGE_ADVANCED_TARGET_NOT_VALID	(90625,"Push message target for statement is not valid")
		, GALLERY_ID_NOT_VALID				(90626,"Id gallery not valid")
		, SEND_MESSAGE_BODY_NULL			(90627,"Input XML request not valid; BODY is null")
		, SEND_MESSAGE_FILTER_INCONSISTENT	(90628,"Input XML request not valid; FILTER is inconsistent")
		, PUSH_CERT_FILE_NOT_FOUND			(90629,"Push, certificate file not found")
		, PUSH_THREAD_NO_MESSAGE_FOUND		(90630,"Push message not found in database")
		, PUSH_CHANNEL_NOT_CONFIGURED		(90631,"Push channel not configured")
		, PUSH_CHANNEL_CONFIG_ERROR			(90632,"Push channel configuration not valid")
		, PUSH_CHANNEL_CONFIG_ERROR_IO		(90633,"Push channel configuration error")
		, PUSH_PROCESSOR_NOT_FOUND			(90634,"Push processor not found for channel category")
		, MESSAGE_FEEDBACK_NOT_VALID		(90635,"Message feedback not valid")
		, CMD_CHECK_NUMBER_NOT_MATCH		(90636,"One or more push command is not valid, check XML")
		, ARG_CHECK_NUMBER_NOT_MATCH		(90637,"One or more argument is not valid, check command XML")
		, ARG_MANDATORY_NOT_FOUND			(90638,"Mandatory argument not found, check command XML")
		, CMD_CHECK_TOO_MANY				(90639,"Too many command found in list")		
		, C2DM_AUTH_KEY_FAIL				(90640,"Google auth key null or not valid")
		, MOBILE_PROVISION_LOAD_IOERROR		(90641,"IOError loading mobile provision file")
		
		//
		, GEOIP_ONLY_ONE_SUPPORTED			(90650,"Only one ip in header response")
		, GEOIP_DATA_FILE_NOT_FOUND			(90651,"GeoIp data file not found")
		, GEOIP_IP_IS_MANDATORY				(90652,"IP is mandatory")
		, GEOIP_IP_IS_NOT_VALID				(90653,"IP is not valid")
		, GEOIP_LOCATOR_IS_NULL				(90654,"GeoIp lookup locator is null")
		, GEOIP_LOCATION_IS_NULL			(90656,"GeoIp location is null")
		, GEOIP_METHOD_NOT_VALID 			(90657,"GeoIp method is not valid")
		//
		//
		, PUSH_SEND_JSON_NULL				(90660,"Input JSON request is null")
		, PUSH_SEND_JSON_NOT_VALID			(90661,"Input JSON request is not valid")
		, PUSH_SEND_JSON_FILTER				(90662,"Input JSON request not valid")
		, PUSH_SEND_JSON_CORE				(90663,"Input JSON request not valid")
		, PUSH_SEND_JSON_GROUP_NULL			(90664,"Input JSON request not valid; application code or id is mandatory")
		, PUSH_SEND_JSON_GROUP_NOT_VALID	(90665,"Input JSON request not valid; application code or id not valid")
		, PUSH_SEND_JSON_BODY_NULL			(90666,"Input XML request not valid; BODY is null")
		, PUSH_SEND_JSON_FILTER_INCONSISTENT(90667,"Input XML request not valid; FILTER is inconsistent")
		, PUSH_SEND_JSON_BODY				(90668,"Input JSON request not valid; body type is null")
		, PUSH_ANALYTICS_FILTER_NULL		(90669,"Insert a filter: 'tag' or 'messageToken'")
		, PUSH_ANALYTICS_FILTER_NOT_FOUND	(90670,"No message found with 'tag' or 'messageToken' filter")
		
		// Classe 90700
		, PUSH_ACTION_NOT_VALID				(90720,"Push action not valid")
		, PUSH_REFRESH_NOT_VALID			(90721,"Device not registered to push service, refresh operation not valid")
		, PUSH_REFRESH_NOT_VALID_DELETED	(90723,"Device not registered to push service (deleted), refresh operation not valid")
		
		, USERS_PROVIDER_NOT_PRESENT		(90730,"Users provider not valid, check instance configuration or add a call parameter")
		, USERS_PROVIDER_CANCELLED			(90731,"Users provider not valid (cancelled), check instance configuration")
		, USERS_PROVIDER_MYDM_NOT_VALID		(90732,"Users provider MyDesktopMate not valid")
		, USERS_PROVIDER_MYDM_CANCELLED		(90733,"Users provider MyDesktopMate not valid (cancelled)")
		, DEVICE_USERS_CORRUPTED_DATA		(90734,"Device user not valid (corrupted database)")
		, USERS_PROVIDER_URL_NOT_FOUND		(90735,"Users provider not found, check URL parameter or server configuration")
		, USERS_PROVIDER_NOT_VALID			(90736,"Users provider not valid, check call parameter or server configuration")
		
		
		, EXPORT_REQUEST_EXPIRED 			(90740,"Export request is expired")
		, EXPORT_TICKET_NOT_FOUND 			(90741,"Export bind ticket not found")
		, EXPORT_FILE_NOT_FOUND				(90742,"Export file not found")
		
		, SESSION_TOKEN_TOO_SHORT			(90748,"Session token not valid (too short, min 10)")
		, SESSION_TOKEN_TOO_LONG			(90749,"Session token not valid (too long, max 32 )")
		, SESSION_TOKEN_NOT_FOUND			(90750,"Session token not valid (not found)")
		, EVENT_CODE_NOT_VALID				(90751,"Event code not valid")
				
		// Classe 90800
		, PS_NOT_VALID_METHOD_GET			(90800,false,false,"HTTP method GET is not supported by this URL")
		, PS_STATEMENT_NOT_SPECIFIED		(90801,false,false,"Specify a valid statement in request call")
		, PS_STATEMENT_NOT_VALID			(90802,"Not valid statement in request call")
		, PS_STATEMENT_DIFFERENCE			(90803,"Difference between header and query string value for statement")
		, PS_REQUEST_CLASS_NOT_FOUND		(90804,"Request class not found")
		, PS_RESPONSE_CLASS_NOT_FOUND		(90805,"Response class not found")
		, PS_REQUEST_UNSUPPORTED_TYPE		(90806,"Internal error, unsupported type class in method")
		, PS_RESPONSE_UNSUPPORTED_TYPE		(90807,"Internal error, unsupported type class")
		, PS_SECURITY_EXCEPTION				(90808,"Internal security exception")
		, PS_NO_SUCH_METHOD					(90809,"Internal error, method not found")
		, PS_INSTANSACTION_ERROR			(90810,"Internal error, class instantiation error")
		, PS_ILLEGAL_ACCESS_ERRROR			(90811,"Internal error, class illegal access")
		, PS_REQUEST_UNSUPPORTED_ATYPE		(90812,"Internal error, unsupported array type class in method")
		, PS_RESPONSE_UNSUPPORTED_ATYPE		(90813,"Internal error, unsupported array type class")
		, PS_REQUEST_CAST_EXCEPTION			(90814,"Not valid value, cast exception")
		//
		
		, PS_PRINT_WRITER_ERROR				(90817,"Error open servlet print writer")
		, PS_OUTPUT_STREAM_ERROR			(90818,"Error open servlet output stream")
		, PS_INPUT_STREAM_ERROR				(90819,"Error reading from input stream")
		, PS_NULL_RESPONSE					(90820,"Null response is not a valid response")
		, PS_RESPONSE_NOT_MATCH				(90821,"Response class not match")
		//
		
		//
		, SYNCHRO_IN_PROGRESS				(90830,"Remote server syncronization in progress, try later")
		, SYNCHRO_IN_PROGRESS_SOFTEC		(90831,"Remote server syncronization in progress (superadmin), try later")
		
		//
		, INSTANCE_UNIQUE_ID_NOT_VALID		(90835,"Identification code not valid")
		
		//
		, VIEWSIZE_NO_VALID_VALUE			(90840,"No valid value for 'viewsize': use WIDTHxHEIGTH")
		, IMAGE_MODE_REQUEST_NOT_VALID		(90841,"Image request mode not valid")		
		, RESOURCE_SIZE_NOT_VALID			(90842,"Image request mode not valid")	
		, IMAGE_ID_OR_SRC_NULL				(90843,"Mandatory field is empty: 'id' or 'src'")		
		
		
		, CUSTOMER_INSTANCE_NOT_MATCH		(90850,"Customer/Instance do not match")
		, SOURCE_CUST_NO_LANG_FOUND			(90851,"Source, no languages found for customer")
		, SOURCE_INST_NO_LANG_FOUND			(90852,"Source, no languages found for instance")
		, SOURCE_NO_TECH_FOUND				(90853,"Source, no technologies found")
		, SOURCE_NO_ZONE_FOUND				(90854,"Source, no zones found")
		, TARGET_CUSTOMER_EXIST				(90855,"Target customer just exists")
		, TARGET_CUSTOMER_EXIST_CANCELLED	(90856,"Target customer just exists (cancelled)")
		, TARGET_INSTANCE_EXIST				(90857,"Target instance just exists")
		, TARGET_INSTANCE_EXIST_CANCELLED	(90858,"Target instance just exists (cancelled)")
		, TARGET_CUST_LANG_NOT_VALID		(90859,"Target, customer language not valid")
		, TARGET_INST_LANG_NOT_VALID		(90860,"Target, instance language not valid")
		, TARGET_TECH_NOT_VALID				(90861,"Target, technology not valid")
		, TARGET_ZONE_NOT_VALID				(90862,"Target, zone not valid")
		, TOO_MANY_RECORDS					(90863,"Too many records")
		, COMPARE_SOURCE_TARGET_ERROR		(90864,"Error compare source/target record")
		, COMPARE_SOURCE_TARGET_EMPTY		(90865,"Source and target list are empty")
		, TARGET_GROUP_EXIST				(90866,"Target group just exists")
		, TARGET_GROUP_NAME_MANDATORY		(90867,"Target group name is mandatory")
		, TARGET_INSTANCE_NAME_MANDATORY	(90868,"Target instance name is mandatory")
		, NO_RECORD_FOUND					(90869,"No record found")
		, NO_APPLICATION_FOUND				(90870,"No application found")
		
		, NO_PARAMER_FOUND					(90875,"No parameter found")
		, NO_PARAMER_MISSING				(90876,"Mandatory parameter missing")
		, NOT_VALID_PARAMER					(90877,"Not valid parameter value")
		, NOT_VALID_PARAMER_STATE			(90878,"Not valid parameter value state")
		, NO_VALID_LINK						(90879,"No valid link")
		
		
		, SERVER_MAINTENANCE				(90888,false,false,"Server maintenance, try later")
		
		// Classe 90900
		, DEVICE_LOCKED						(90970,false,false,"Application locked on this device")
		
		, REQUEST_METHOD_NOT_VALID			(90979,"Http request method not valid (POST mandatory)")	
		, REQUEST_NOT_IMPL_ISREADER			(90980,"Internal error, request must implements interface to perform operation")		
		, DB_COMPARE_CLASS_NOT_MAPPED		(90981,"Class not managed from database field comparator")
		, DB_FILED_NOT_MAPPED				(90982,"Database filed not mapped")
		, REQUEST_IS_NULL					(90983,"Internal error, request is null")				
		, REQUEST_PHASE_IS_NULL				(90984,"Request phase is null")		
		, REQUEST_PHASE_IS_NOT_VALID		(90985,"Request phase is not valid")		
		, MFD_REQUEST_IO_ERROR				(90986,"MultipartFormData request is not valid") 
		, MDF_REQUEST_UPLOAD_ERROR			(90987,"MultipartFormData request upload error") 
		, MDF_REQUEST_NOT_VALID				(90988,"Request is not a valid MultipartFormData") 
		, DB_VALUE_CLASS_NOT_MAPPED			(90989,"Class not managed from database field value function")
		, SQL_TIMEOUT						(90990,"Error in accessing the database (timeout)")	
		, INTERNAL_SERVER_ERROR				(90991,"Internal server error") 
		, MANAGER_EXCEPTION					(90992,"Server manager exception") 
		, REMOTE_EXCEPTION					(90993,"Problem contacting remote server") 
		, SQL_EXCEPTION						(90994,"Error in accessing the database")	
		, UNHANDLED_EXCEPTION				(90995,"Unhandled error")
		, SERVICE_NOT_ACTIVE				(90996,"Service is not active") 				// Servizio disattivato
		, SESSION_NOT_VALID					(90997,"Session null or not valid") 
		, REQUEST_NOT_VALID					(90998,"Request is not valid") 
		, RESPONSE_NOT_VALID				(90999,"Response is not valid") 				// Valore di default
		
		// FILE PROXY CUSTOM
		, PATH_NOT_VALID					(30001,"Path not valid or not found")	
		, FILE_NOT_EXIST					(30002,"File do not exist")	
		, FILE_IS_DIRECTORY					(30003,"This is not a file")	
		, ERROR_DELETING_FILE				(30004,"Error deleting file")
		, FILE_JUST_EXIST					(30005,"File just exist")	
		, FILE_NOT_FOUND					(30006,"File not found")	
		, ERROR_COPY_FILE_TEMP				(30007,"Error creating temp file for append")
		, DIRECTORY_JUST_EXIST				(30008,"Directory just exist")	
		, ERROR_CREATING_DIR				(30009,"Error creating directory")
		, FOUND_NOT_VALID_CHAR				(30010,"Found not valid char in path or filename")
		, USER_NOT_VERIFY_RETRY				(30011,"Error in user verification, retry!")
		
		//-----------------
		
		
		
		
		// Warning, CLASSE 100
		
		
		;
	
	// FIXME migliorare con Class     "it.softecspa.desktopmate.services.common
    public static final String BUNDLE_NAME = "it/softecspa/fileproxy/services/common/lang/ResponseOutcome";
		  
		  
	public static boolean checkOK(String value) {
		if (value==null) return false;
		
		if (value.equals(OK.getReturnCode())) return true;
		return false;
	}
	
	
		
	private int id;	  
	private String code;
	private String message;
	private boolean traceLog;
	private boolean traceErrorCall;
	
	private ResponseOutcome(int id, String message) {
		this.id = id;
		this.code = Integer.toString(id);
		this.message = message;
		this.traceLog = true;
		this.traceLog = false;
	}
	
	private ResponseOutcome(int id, boolean traceLog, boolean traceErrorCall, String message) {
		this.id = id;
		this.code = Integer.toString(id);
		this.message = message;
		this.traceLog = traceLog;
		this.traceErrorCall = traceErrorCall;
	}

	public String getReturnCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public int getId() {
		return id;
	}
	
	public boolean isOk() {
		return id==OK.getId();
	}

	public String getFullMessage() {
		return "("+id+") "+message;
	}

	/**
	 * Indica se l'errore deve essere tracciato in modo completo nel file di log
	 * @return
	 */
	public boolean isTraceLog() {
		return traceLog;
	}

	/**
	 * Indica se l'errore deve essere traccciato nel database come "error call"
	 * @return
	 */
	public boolean isTraceErrorCall() {
		return traceErrorCall;
	}
	
		
}
