package it.softecspa.fileproxy.services.common;




@SuppressWarnings("serial")
public class UniversalStatementException extends Throwable implements TraceableWithIdException  {

	private String id;
	private boolean trace;
	
	
	public UniversalStatementException(Throwable e) {
		super(ResponseOutcome.INTERNAL_SERVER_ERROR.getMessage(),e);
		this.id = ResponseOutcome.INTERNAL_SERVER_ERROR.getReturnCode();
		this.trace = ResponseOutcome.INTERNAL_SERVER_ERROR.isTraceLog();
	}
	
	
	public UniversalStatementException(String message, Throwable e) {
		super(message, e);
		this.id = ResponseOutcome.INTERNAL_SERVER_ERROR.getReturnCode();
		this.trace = ResponseOutcome.INTERNAL_SERVER_ERROR.isTraceLog();
	}
	
	public UniversalStatementException(String id, String message) {
		super(message);
		this.id = id;
		this.trace = true;
	}
	
		
	public UniversalStatementException(ResponseOutcome outcome, Throwable e) {
		super(outcome.getMessage(), e);
		this.id = outcome.getReturnCode();
		this.trace = outcome.isTraceLog();
	}
	
	public UniversalStatementException(ResponseOutcome outcome) {
		super(outcome.getMessage());
		this.id = outcome.getReturnCode();
		this.trace = outcome.isTraceLog();
	}

	@Override
	public String getId() {
		return id;
	}
	
	@Override
	public boolean isTraceLog() {
		return trace;
	}
	
	@Override
	public boolean isTraceErrorCall() {
		return false;
	}

	@Override
	public String getMessage() {
		return super.getMessage();
	}
}
