package it.softecspa.fileproxy.services.common.comunicator.http;

import javax.servlet.http.HttpServletRequest;

public class HttpRemote {

	/**
	 * These are some environment variables: 
	 * REMOTE_ADDR - IP address of a client 
	 * 
	 * HTTP_VIA - if it is not empty, then a proxy is used. Value is an
	 * address (or several addresses) of a proxy server, this variable is added
	 * by a proxy server itself if you use one. 
	 * 
	 * HTTP_X_FORWARDED_FOR - if it is not empty, then a proxy is used. Value is a real IP address of a client
	 * (your IP), this variable is also added by a proxy server if you use one.
	 * 
	 * HTTP_ACCEPT_LANGUAGE - what language is used in browser (what language a
	 * page should be displayed in) HTTP_USER_AGENT - so called
	 * "a user's agent". HTTP_HOST - is a web server's name In fact there are
	 * much more of them. Your anonymity is determined by what environment
	 * variables "hide" from a web-server.
	 * 
	 *  Proxy server is not used: REMOTE_ADDR = your IP HTTP_VIA = not
	 * determined HTTP_X_FORWARDED_FOR = not determined
	 * 
	 *  Transparent Proxies REMOTE_ADDR = proxy IP HTTP_VIA = proxy IP
	 * HTTP_X_FORWARDED_FOR = your IP These proxies are not anonymous. They
	 * don't hide IP-address of a client and let a web server know that you are
	 * surfing through a proxy server. The task of such proxies, as a rule, is
	 * information caching and/or support of Internet access for several
	 * computers via single connection. Such proxies are not applicable for
	 * security and privacy while surfing on net. You can use them only for
	 * network speed improvement.
	 * 
	 *  Anonymous Proxies REMOTE_ADDR = proxy IP HTTP_VIA = proxy IP
	 * HTTP_X_FORWARDED_FOR = proxy IP These proxies don't show your real IP but
	 * change the request fields so it is very easy to detect that you are using
	 * proxy.
	 * 
	 *  High Anonymous Proxies REMOTE_ADDR = proxy IP HTTP_VIA = not determined
	 * HTTP_X_FORWARDED_FOR = not determined High Anonymous proxy servers do not
	 * pass an IP-address of a client and don't send any variables indicating
	 * that you are using proxy server to host and look like real browser.
	 */

	/*
	 * TODO da valutare 
	 function ipCheck() { 
	   	if (getenv('HTTP_CLIENT_IP')) { 
	   		$ip = getenv('HTTP_CLIENT_IP'); 
	   	} elseif (getenv('HTTP_X_FORWARDED_FOR')) {
	   		$ip = getenv('HTTP_X_FORWARDED_FOR'); 
	   	} elseif (getenv('HTTP_X_FORWARDED')) { 
	   		$ip = getenv('HTTP_X_FORWARDED'); 
	   	} elseif (getenv('HTTP_FORWARDED_FOR')) { 
	   		$ip = getenv('HTTP_FORWARDED_FOR'); 
	   	} elseif (getenv('HTTP_FORWARDED')) { 
	   		$ip = getenv('HTTP_FORWARDED'); 
	   	} else { 
	   		$ip = $_SERVER['REMOTE_ADDR']; 
	   	} 
	   	return $ip; 
	 }
	 */

	//private HttpServletRequest request;
	private boolean proxy;
	
	private String remoteAddr;
	
	private String remoteHost; 	// IP con cui si presenta l'host collegato (IP pubblico)
	private String forwarded; 	// IP dell'host se presente proxy 
	private String address; 	// IP del proxy o dell'host se non presente proxy  (IP privato)

	private String traceHost; 	// trace root

	private Browser browser;
	private String via;
	
	
	private String remote_user;
	private String user_agent;
	private String referer;
	private String content_type;
	private String max_forwards;
	
	
	

	// FIXME aggiungere controllo velocizzatore che elabora i dati alla prima richiesta
	public HttpRemote(HttpServletRequest request) {
		
		remoteAddr = request.getRemoteAddr(); 				// REMOTE_ADDR		
		address = request.getRemoteAddr(); 					// REMOTE_ADDR
		
		forwarded = request.getHeader("x-forwarded-for"); 	// HTTP_X_FORWARDED_FOR
		via = request.getHeader("Via"); 					// HTTP_VIA

		if (forwarded != null) {
			String remoteIP = null;
			String forwardPROXY = null;
			if (forwarded.indexOf(",") >= 0) {
				int p = forwarded.indexOf(",");
				remoteIP = forwarded.substring(0, p).trim();
				forwardPROXY = forwarded.substring(p + 1).trim();
			} else {
				remoteIP = forwarded;
			}
			// Warkaround per hidden proxy
			if (remoteIP.equalsIgnoreCase("unknown")) {
				remoteIP = address;
				forwarded = address;
			}

			String xvia = (via != null && !via.equals(forwarded) ? ": " + via : "");
			if (forwarded.equalsIgnoreCase(address)) {
				// PROXY ANONIMO
				traceHost = forwarded + " (proxy" + xvia + ")";
			} else {
				// PROXY TRASPARENTE
				if (forwardPROXY != null) {
					address = forwardPROXY + ", " + address; // Concateno il
					// proxy
					// intermedio
					traceHost = remoteIP + " [" + address + " (proxy" + xvia + ")]";
				} else {
					traceHost = forwarded + " [" + address + " (proxy" + xvia + ")]";
				}
			}
			proxy = true;
			remoteHost = remoteIP;

		} else {
			// NO proxy o proxy bloccante
			traceHost = address;
			proxy = false;
			remoteHost = address;
		}

		/*
		 * String headers=""; for (Enumeration
		 * enumeration=request.getHeaderNames();enumeration.hasMoreElements();)
		 * { String nome = (String) enumeration.nextElement();
		 * headers+=nome+" = "+request.getHeader(nome)+"\n"; }
		 */
		
		remote_user = request.getRemoteUser();
		user_agent = request.getHeader("user-agent");
		referer = request.getHeader("referer");
		content_type = request.getHeader("content-type");
		max_forwards = request.getHeader("max-forwards");
		
	}

	

	public String getTraceHost() {
		return traceHost;
	}

	
	/**
	 * Indirizzo pubblico con cui si presenta l'host remoto
	 * @return
	 */	
	public String getRemoteHost() {
		return remoteHost;
	}

	/**
	 * Indirizzo privato del server da cui proviene la chiamata
	 * Protebbe essere un proxy
	 * @return
	 */
	public String getRemoteAddress() {
		return address;
	}

	
	public String getForwardedFor() {
		return forwarded;
	}

	public boolean hasProxy() {
		return proxy;
	}

	public String getRemoteUser() {
		return remote_user;
	}
	
	public String getUserAgent() {
		return user_agent;
	}

	public String getReferer() {
		return referer;
	}

	public String getContentType() {
		return content_type;
	}

	public String getMaxForwards() {
		return max_forwards;
	}

	
	public Browser getBrowser() {
		if (browser == null)
			browser = new Browser(this);
		return browser;
	}

	public String printlnInfo() {
		return getTraceHost() + (getMaxForwards() != null ? " (" + getMaxForwards() + ")" : "") + (getRemoteUser() != null ? " {" + getRemoteUser() + "}" : "");
	}

	
	/**
	 * Returns the Internet Protocol (IP) address of the client or last proxy that sent the request.
	 * @return
	 */
	public String getRemoteAddr() {
		return remoteAddr;
	}

}
